﻿//-----------------------------------------------------------------------------
// cSpell: ignore idjs
// cSpell: ignore ioreg
// cSpell: ignore Prefs
// cSpell: ignore siteid
// cSpell: ignoreRegExp /\([a-z]+(\d)*\)/i
//-----------------------------------------------------------------------------
$.level = 0;
//@targetengine 'com.townnews.BLOXTotalCMS';
/* Debugger path:
BLOX_Total_CMS/Startup Scripts/townnews-plug-in.jsx
*/




//-----------------------------------------------------------------------------
//-- C O P Y R I G H T   A N D   L I C E N S I N G
//-----------------------------------------------------------------------------
//--
//-- Copyright © 2024, BLOX Digital
//--
//-- Redistribution of this source code must retain the above copyright
//--	notice, and the accompanying conditions and legal disclaimer.
//--
//-- Redistributions in all forms (binary, printed, audio, video, etc.)
//--	must reproduce the above copyright notice, these conditions, and
//--	the below disclaimer in all forms provided with the distributions.
//--
//-- electronic publishing support does not endorse or promote products
//--	derived from this software without specific prior permission
//--	in writing.
//--
//-- This software is provided by the copyright holders and contributors
//--	"As is" and any express or implied warranties, including, but not
//--	limited to, the implied warranties of merchantability and fitness
//--	for a particular purpose are disclaimed. In no event shall the
//--	regents or contributors be liable for any direct, indirect,
//--	incidental, special, exemplary, or consequential damages
//--	(including, but not limited to, procurement of substitute goods
//--	or services; loss of use, data, or profits; or business
//--	interruption) however caused and on any theory of liability,
//--	whether in contract, strict liability, or tort (including
//--	negligence or otherwise) arising in any way out of the use of
//--	this software, even if advised of the possibility of such damage.
//--
//-----------------------------------------------------------------------------


//-- Purpose: to load the appropriate compiled and non-compiled resources
//--	which allow the BLOX Total CMS Plug-In to operate. After loading,
//--	this calls the key launch sequence items, requests login, and if
//--	login isn't an option, then will uninstall all visible features.
//
//-----------------------------------------------------------------------------
//-- Note, the following is a method which much be defined prior to its use.
//
//
File.prototype.nameWithoutExtension = function (pullAllExtensions_b) {

	//-------------------------------------------------------------------------
	//-- N A M E   W I T H O U T   E X T E N S I O N
	//-------------------------------------------------------------------------
	//-- Generic: Yes for ExtendScript. Not JavaScript.
	//-------------------------------------------------------------------------
	//-- Purpose: to return the name of the file without the file extension.
	//-------------------------------------------------------------------------
	//-- Parameters: None. It is a method.
	//-------------------------------------------------------------------------
	//-- Calls: Nothing.
	//-------------------------------------------------------------------------
	//-- Returns: The name without the extension or the original name if no
	//--	file extension is used.
	//-------------------------------------------------------------------------
	//-- Sample Use:
	//~ 	var fileRef = File.saveDialog ('Pick an Adobe InDesign File', '*.indd' ) ;
	//~ 	var baseName = fileRef.nameWithoutExtension() ;
	//-------------------------------------------------------------------------
	//-- Written: 2009.09.21 by Jon S. Winters of electronic publishing support
	//-- eps@electronicpublishingsupport.com
	//-------------------------------------------------------------------------

	//-- Get the original name ;
	var fullName_s = this.name;
	var finalDotPosition_i = 0;

	//-- Locate the final position of the final . before the extension.
	//-- 5.36.38.2019.07.31 INDESIGN-1935 adding new option to strip off all
	//-- dot (.) patterns which might be stacked extensions
	if (pullAllExtensions_b === true) {

		finalDotPosition_i = fullName_s.indexOf(".");

	} else {

		finalDotPosition_i = fullName_s.lastIndexOf(".");

	}
	//-- check that position. If it isn't -1 (missing) return the text
	//--		up to that position.
	//-- Note, there are some odd things that can happen when passing
	//--		a file reference that begins with a single dot. Be wary.
	if (finalDotPosition_i > -1) {

		return fullName_s.substr(0, finalDotPosition_i);

	}

	//-- implied else, return the original name because there is no dot.
	return fullName_s;

}
//
//
Folder.prototype.getFilesWithSuffix = function (includeFilesWithThisSuffix) {

	//-------------------------------------------------------------------------
	//-- G E T   F I L E S   W I T H   S U F F I X
	//-------------------------------------------------------------------------
	//-- Generic: Yes!
	//-------------------------------------------------------------------------
	//-- Purpose: To create a folder based search method for files containing
	//--	suffixes that works on both Windows and Mac OS. Windows searching
	//--	works fairly easily, Mac OS X not so nice with ExtendScript. This
	//--	provides a generic method for handling files with suffixes.
	//-------------------------------------------------------------------------
	//-- Parameters:
	//--	includeFilesWithThisSuffix: a STRING for the suffix
	//-------------------------------------------------------------------------
	//-- Calls: Mac OS calls an internal function.
	//-------------------------------------------------------------------------
	//-- Returns: an array of FILE objects.
	//--	Or an empty array if nothing is returned.
	//-------------------------------------------------------------------------
	//-- Sample Use: var images = (Folder.desktop).getFilesWithSuffix ('.jpg')
	//-------------------------------------------------------------------------
	//-- Notes: Do not send it an * or other wild card. Mac OS could return
	//--	files with the suffix not at the end.
	//-------------------------------------------------------------------------
	//-- Written: 2011.06.17 by Jon S. Winters of TownNews
	//-- (c) 2017 TownNews All rights reserved
	//-------------------------------------------------------------------------

	//-- 4.70.10, 2012.01.03, make sure there are no . files
	var ra = new Array();
	var allFilesWithSuffix = this.getFiles('*' + includeFilesWithThisSuffix);
	//-- make sure there was something found. The loop doesn't run if the length is zero
	for (var fi = 0; fi < allFilesWithSuffix.length; fi++) {

		if (allFilesWithSuffix[ fi ].name.substr(0, 1) != '.') {

			ra.push(allFilesWithSuffix[ fi ]);

		}
	}

	return ra;

}
//
//
Folder.prototype.verify = function () {

	//-------------------------------------------------------------------------
	//-- V E R I F Y
	//-------------------------------------------------------------------------
	//-- Generic: Yes
	//-------------------------------------------------------------------------
	//-- Purpose: A folder object method to verify if the folder specified
	//--		actually exists. If the folder doesn't exist, the method will
	//--		attempt to create it.
	//-------------------------------------------------------------------------
	//-- Returns: True if the folder exists, false if it couldn't create it.
	//-------------------------------------------------------------------------
	//-- Sample Call:
	//--		Folder ( '~/IsItHere' ).verify() ;
	//-------------------------------------------------------------------------
	//-- Calls: Nothing
	//-------------------------------------------------------------------------
	//-- Written 2009.09.19 on board US Airways flight 4376.
	//-- eps@electronicpublishingsupport.com
	//-------------------------------------------------------------------------

	if (this.exists) {

		return true;

	} else {
		//-- Create an array like a stack of folders that will need
		//--		to be created.
		var foldersToCreate = new Array();
		//-- Create a local copy of the original folder
		//--		because it needs to be modified within
		//--		this routine.
		//--		Using the absoluteURI version of the name to point
		//--			all the way through to the sever. Only this version
		//--			of the activeFolder needs to use this absoluteURI
		//--			notation because.
		var activeFolder = new Folder(this.absoluteURI);

		//-- Loop through the path structure until every part of
		//--		of the folder path is checked. Any non-existent
		//--		folder path will be added to the array to create.
		while (!activeFolder.exists) {
			//-- 4.39.15, have noticed or a long time that if
			//--	the .path is not good that it will generate a path
			//--	to one of the scripting folders.
			if (activeFolder.path == '') {

				return false;
			}

			//-- Add the activeFolder to the array of folders to create
			foldersToCreate.push(activeFolder);
			//-- Now get to the parent of the folder.
			//--		Can't use .parent because if the active folder
			//--			doesn't exist, it won't have a parent.
			activeFolder = new Folder(activeFolder.path);

		}

		//-- At this point we have an array of folders that need to be
		//--		created. The array will have one element too many because
		//--		of the final line of the
		while (foldersToCreate.length > 0) {

			//-- Remove the last item added to the array of folders to create
			activeFolder = foldersToCreate.pop();
			//-- Try to create this folder
			if (!activeFolder.create()) {

				return false;

			} //-- end of if create

		} //-- end of lower while

	} //-- end of else from way up top

	//-- At this point the folder has to exist else we already returned false
	return true;

}
//
//
Image.prototype.onDraw = function () {

	//-------------------------------------------------------------------------
	//-- S C R I P T   U I   O V E R R I D E   O N   D R A W   --   S C A L E
	//-------------------------------------------------------------------------
	//-- Purpose: To cause images in script UI dialogs to scale DOWN to fit
	//--	their container.
	//-------------------------------------------------------------------------
	//-- Originally written by Marc Autret, found in ScriptUI for Dummies
	//--	modified for 5.20.32 by Jon S. Winters on 2017.09.07
	//-------------------------------------------------------------------------

	var err;
	var k_n;
	var localError;
	var containerWidthHeight_a = [];
	var imageWidthHeight_a = [];
	var xy_a = [];

	try {

		if (!this.image) {

			return;
		}

		//-- get the size of the container and the size of the image
		//--	These are arrays
		containerWidthHeight_a = this.size;
		imageWidthHeight_a = this.image.size;

		//-- find the best scale to use with no enlargements.
		k_n = Math.min(containerWidthHeight_a[ 0 ] / imageWidthHeight_a[ 0 ], containerWidthHeight_a[ 1 ] / imageWidthHeight_a[ 1 ], 1);

		//-- Calculate the scale Resize proportionally:
		imageWidthHeight_a = [ k_n * imageWidthHeight_a[ 0 ], k_n * imageWidthHeight_a[ 1 ] ];

		//-- Calculate the position of the center
		xy_a = [ (containerWidthHeight_a[ 0 ] - imageWidthHeight_a[ 0 ]) / 2, (containerWidthHeight_a[ 1 ] - imageWidthHeight_a[ 1 ]) / 2 ];

		//-- now redraw it at the potentially new size, but in the
		//--	middle of the image's frame
		this.graphics.drawImage(this.image, xy_a[ 0 ], xy_a[ 1 ], imageWidthHeight_a[ 0 ], imageWidthHeight_a[ 1 ]);

		//-- clear out the three arrays
		containerWidthHeight_a = imageWidthHeight_a = xy_a = null;

	} catch (err) {

		localError = err;

		debugger;

	}

}
//-----------------------------------------------------------------------------

//-- MAIN BODY -- not a function call. This must be this way to load the
//--	functions in the jsx and jsxbin files into the global namespace.
try {

	var err;
	//-- 5.37.06.2019.06.11 INDESIGN-1941 to allow the new ExtendScript
	//-- debugger to properly function correctly, we should NOT keep
	//--	any prior cached items. These should all be replaced.
	//-- 5.37.06.2019.06.11 INDESIGN-1941 check to see if there are
	//--	global objects from a prior running in debugger
	//-- 5.38.01.2019.07.11 INDESIGN-2586 add more options

	if ($.level && this.hasOwnProperty('com') &&
		this.com.hasOwnProperty('townnews') &&
		this.com.townnews.hasOwnProperty('BLOXTotalCMS') &&
		this.com.townnews.BLOXTotalCMS.hasOwnProperty('tncms') &&
		this.com.townnews.BLOXTotalCMS.tncms.hasOwnProperty('loggedIn') &&
		(this.com.townnews.BLOXTotalCMS.tncms.loggedIn === true) &&
		this.com.townnews.BLOXTotalCMS.hasOwnProperty('servers') &&
		this.com.townnews.BLOXTotalCMS.servers.hasOwnProperty('activeSite') &&
		isNonEmptyString(this.com.townnews.BLOXTotalCMS.servers.activeSite)) {

		//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
		this.debug_o = {};
		this.debug_o.loggedIn = true;

		// this.debug_o.passwordEncoded_s = this.com.townnews.BLOXTotalCMS.tncms.password;
		// this.debug_o.redirect_b = null;
		// this.debug_o.serverName_s = this.com.townnews.BLOXTotalCMS.tncms.serverName;
		// this.debug_o.servers = this.com.townnews.BLOXTotalCMS.servers; // 2020.04.05 testing
		// //-- substr pulls of a slash
		// this.debug_o.tunnel_b = null;
		// this.debug_o.userName_s = this.com.townnews.BLOXTotalCMS.tncms.userName;
		// //-- 5.38.01.2019.07.11 INDESIGN-1586 store the naming convention
		// //--	and the development mode
		// if (this.com.townnews.BLOXTotalCMS.hasOwnProperty('namingConvention')) {
		// 	this.debug_o.namingConvention_o = this.com.townnews.BLOXTotalCMS.namingConvention;
		// }
		// if (this.com.townnews.BLOXTotalCMS.hasOwnProperty('developmentModeActive')) {
		// 	//force a Boolean
		// 	this.debug_o.developmentModeActive_b = (!!this.com.townnews.BLOXTotalCMS.developmentModeActive);
		// 	// $.bp(this.debug_o.developmentModeActive_b);
		// }
		this.com.townnews.BLOXTotalCMS.launch = {};
		this.com.townnews.BLOXTotalCMS.launch.ll = this.com.townnews.BLOXTotalCMS.log;
		this.com.townnews.BLOXTotalCMS.launch.msg = '';
		this.com.townnews.BLOXTotalCMS.launch.reg = this.com.townnews.BLOXTotalCMS.launch.ll.reg('townnews-plug-in', [ 'handleError' ], true);

	} else {

		delete this._TranslateMenu;
		delete this.activeDialog;
		delete this.BLOXTotalCMS;
		delete this.com;
		delete this.JSON;
		delete this.tncms;
		delete this.domainsAndTheServersThatHostThemFrom

		//-- 5.43.10.2020.06.16 INDESIGN-2897 delete more globals
		delete this.cmsDomain;
		delete this.docAndPageFromFrameCounter;
		delete this.ignoreEvents;
		delete this.localSearchDialog;


		//-- 5.44.02.2020.08.10 INDESIGN-2569 removed a comment

		//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
		this.com = {};
		this.com.townnews = {};
		this.com.townnews.BLOXTotalCMS = {};

		//-- 5.42.09.2020.01.30 INDESIGN-2766 make sure that debug has a value
		this.debug_o = null;

	}

	//-- 5.53.15.2021.09.13 INDESIGN-3439 add a new variable for triedToDie_b
	if (!this.com.townnews.BLOXTotalCMS.hasOwnProperty('launch')) {

		this.com.townnews.BLOXTotalCMS.launch = {};

	}
	this.com.townnews.BLOXTotalCMS.launch.triedToDie_b = false;
	//-- 5.53.15.2021.09.13 INDESIGN-3439 this menuName is defined in multiple
	//--	places, but adding it here so that if login fails, the menu can be
	//--	removed
	this.com.townnews.BLOXTotalCMS.menuName = 'BLOX Total CMS';

	//-- 4.66.04, 2012.06.07, add the global object onto the app itself.
	//-- 5.37.06.2019.06.11 INDESIGN-1941, if we aren't in debug mode,
	//--	don't replicate this object. This MIGHT cause issues
	//-- 5.43.02.2020.04.05 INDESIGN-2766 force it to be in this.
	if ($.level > 0) {

		this.BLOXTotalCMS = this.com.townnews.BLOXTotalCMS;

	}
	//-- All of this needs to remain text. This is just programmer information.
	//--	but it does show up in the About dialog.
	this.com.townnews.BLOXTotalCMS.scriptName = 'BLOX Total CMS';

	/*
	##     ##  ########  ########    ######   ####   #######   ##    ##
	##     ##  ##        ##     ##  ##    ##   ##   ##     ##  ###   ##
	##     ##  ##        ##     ##  ##         ##   ##     ##  ####  ##
	##     ##  ######    ########    ######    ##   ##     ##  ## ## ##
	 ##   ##   ##        ##   ##          ##   ##   ##     ##  ##  ####
	  ## ##    ##        ##    ##   ##    ##   ##   ##     ##  ##   ###
	   ###     ########  ##     ##   ######   ####   #######   ##    ##
	*/

	//-- Script Version Number -- to be maintained by the script writer/editor
	this.com.townnews.BLOXTotalCMS.scriptEditDate = "2025.05.19";// separated by periods
	this.com.townnews.BLOXTotalCMS.scriptVersion = "5.77.00";// separated by periods
	this.com.townnews.BLOXTotalCMS.scriptBuildNumber = "07";// always 2 digits
	//------------------------------------------------------------------

	//-- 5.14.52.2016.09.07 INDESIGN-1230 disable these options as part
	//--	of the effort to remove these options completely
	//~ this.com.townnews.BLOXTotalCMS.AdMarketStandAlone = false ;
	//~ this.com.townnews.BLOXTotalCMS.AdOwlStandAlone = false ;

	//-- 5.29.01.2018.03.19 INDESIGN-2108 Remove hard coded setting
	//~ this.com.townnews.BLOXTotalCMS.forceCrossPlatformLinks = false ;

	//------------------------------------------------------------------

	//-- 5.16.06.2016.12.02 INDESIGN-1522 make a new combined variable
	//--	with the build number included.
	this.com.townnews.BLOXTotalCMS.scriptVersionNumberWithBuild = this.com.townnews.BLOXTotalCMS.scriptVersion + '-' + this.com.townnews.BLOXTotalCMS.scriptBuildNumber;


	//------------------------------------
	//-- H O S T   I N F O R M A T I O N
	//------------------------------------

	//--	being used and what operating system is in use. This is overkill, but
	//--	it provides all possible information before the 'includes'.
	//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
	this.com.townnews.BLOXTotalCMS.host = {};
	//-- Version 3.91 revised version tracking again.


	//--------------------
	//-- L A N G U A G E
	//--------------------
	//-- 5.61.00-7.2022.06.08 INDESIGN-3849 add the language. The default is en-US.
	this.com.townnews.BLOXTotalCMS.host.language_s = 'en';
	try {

		this.com.townnews.BLOXTotalCMS.host.language_s = String($.locale).split('_')[ 0 ].toLowerCase();

	} catch (err) {

		debugger;

		this.com.townnews.BLOXTotalCMS.host.language_s = 'en';

	}
	//-- set a deafult language primarily for the launch process. 
	this.com.townnews.BLOXTotalCMS.host.languageIsDefault_b = (this.com.townnews.BLOXTotalCMS.host.language_s == 'en');


	//-- 4.71.52.2013.06.06 add a clean name of the host
	this.com.townnews.BLOXTotalCMS.host.appCleanName = app.name.replace(new RegExp('[\\W\\.]', 'g'), '_');

	//-- 5.30.01.2018.03.27 INDESIGN-232 add a Display name for the host
	this.com.townnews.BLOXTotalCMS.host.appDisplayName = app.name.replace(new RegExp('[\\W\\.]', 'g'), ' ');

	//-- 4.42.01 -- Bug in the original version code
	//-- 4.71.90e.2013.08.26 in Tucson, AZ Support upgraded versions of
	//--	Creative Cloud
	//-- 4.72.43.2014.01.20 Support upgraded versions of Creative Cloud
	//--	as Adobe Recently released CC 9.2.x
	//-- 5.06.04.2014.09.26 set the CC 2014 version number correctly. Add
	//--	support for expected updates.
	try {

		//-- 5.10.04.2015.01.28 INDESIGN-396 include CS 6.1 as
		//--	an update for CS 6
		//-- 5.12.12.2015.06.17 Add more CC versions.
		//-- 5.15.24.2016.09.02 Add more CC version for 2014 and 2015
		//-- 5.15.39.2016.11.04 Support change to 2017 CC. Was expecting 2016
		//-- 5.20.10.2017.07.06 INDESIGN-1821 add warnings for non-upgraded CS5
		//-- 5.20.31.2017.09.06 INDESIGN-1821 Convert the property names to
		//--	strings because the dotted numbers weren't working.
		//-- 5.34.04.2018.11.01 INDESIGN-2344 add support for CC 2019
		//-- 5.38.01.2019.07.16 INDESIGN-2586 add a few future versions for
		//--	the sites that don't update the clients regularly
		//-- 5.41.05.2019.11.12 Update to list Creative Cloud 2020
		//-- 5.41.10.2019.12.05 INDESIGN-2715. Needed to change CC 2020 to
		//--	CC 2020.0 to allow Spawn Template to recognize the
		//--	version number.
		//-- 5.44.09.2020.10.29 Adding the next versions
		//-- 5.53.01.2021.07.21 adding for Creative Cloud 2021.3
		//-- 5.53.13.2021.09.01 adding a few more 2021 versions
		//-- 5.54.01.2021.10.26 adding more versions now that 2022
		//--	has been released
		//-- 5.66.00-31.2023.09.29 INDESIGN-4158 support InDesign
		//--	version 18.5 which was released to support UXP
		this.com.townnews.BLOXTotalCMS.host.versionObject = {
			"70": 'CS 5', "75": 'CS 5.5', "75.0": 'CS 5.5.0', "75.1": 'CS 5.5.1', "75.2": 'CS 5.5.2', "75.3": 'CS 5.5.3',
			"80": 'CS 6', "81": 'CS 6.1', "82": 'CS 6',
			"90": 'CC', "91": 'CC.1', "92": 'CC.2', "93": 'CC.3', "94": 'CC.4',
			"100": 'CC 2014', "101": 'CC 2014.1', "102": 'CC 2014.2', "103": 'CC 2014.3', "104": 'CC 2014.4',
			"110": 'CC 2015', "111": 'CC 2015.1', "112": 'CC 2015.2', "113": 'CC 2015.3', "114": 'CC 2015.4', "115": 'CC 2015.5', " 116": 'CC 2015.6',
			"120": 'CC 2017.0', "121": 'CC 2017.1', "122": 'CC 2017.2', "123": 'CC 2017.3',
			"130": 'CC 2018.0', "131": 'CC 2018.1',
			"140": 'CC 2019.0', "141": 'CC 2019.1', "142": 'CC 2019.2',
			"150": 'CC 2020.0', "151": 'CC 2020.1', "152": 'CC 2020.2',
			"160": 'CC 2021.0', "161": 'CC 2021.1', "162": 'CC 2021.2', "163": 'CC 2021.3', "164": 'CC 2021.4', "165": 'CC 2021.5', "166": 'CC 2021.6',
			"170": 'CC 2022.0', "171": 'CC 2022.1', '172': 'CC 2022.2', '173': 'CC 2022.3', '174': 'CC 2022.4',
			"180": 'CC 2023.0', "181": 'CC 2023.1', '182': 'CC 2023.2', '183': 'CC 2023.3', '184': 'CC 2023.4', '185': 'CC 2023.5', '186': 'CC 2023.6',
			"190": 'CC 2024.0', '191': 'CC 2024.1', '192': 'CC 2024.2', '193': 'CC 2024.3', '194': 'CC 2024.4', '195': 'CC 2024.5', '196': 'CC 2024.6', '197': 'CC 2024.7', '198': 'CC version not known',
			"200": 'CC 2025.0', '201': 'CC 2025.1', '202': 'CC 2025.2', '203': 'CC 2025.3', '204': 'CC version not known',
			"210": 'CC 2026.0', '211': 'CC 2026.1', '212': 'CC 2026.2', '213': 'CC 2026.3', '214': 'CC version not known',
			"220": 'CC version not known'

		};

		//-- 5.16.11.2016.12.30 INDESIGN-1548 the method broke after reaching
		//--	CC 2014 because the digits switched to 2 from one.
		//-- 5.20.31.2017.09.06 INDESIGN-1821 force this to a string.
		//-- 5.20.34.2018.09.11 INDESIGN-850 now we need
		//--	both a string and a number version
		this.com.townnews.BLOXTotalCMS.host.av = app.version;
		this.com.townnews.BLOXTotalCMS.host.versionPointer_n = this.com.townnews.BLOXTotalCMS.host.av.substr(0, this.com.townnews.BLOXTotalCMS.host.av.indexOf('.', String(Math.floor(this.com.townnews.BLOXTotalCMS.host.av.substr(0, this.com.townnews.BLOXTotalCMS.host.av.indexOf('.') + 1))).length + 1)) * 10;
		this.com.townnews.BLOXTotalCMS.host.versionPointer_s = String(this.com.townnews.BLOXTotalCMS.host.versionPointer_n);

		//-- 5.20.10.2017.07.06 INDESIGN-1821, provide a warning for unupdated
		//--	versions of Adobe InDesign CS 5.5
		//-- 5.21.03.2017.09.29 trying a different formula
		//~ 		if (this.com.townnews.BLOXTotalCMS.host.versionPointer_s == "75") {
		if (this.com.townnews.BLOXTotalCMS.host.versionPointer_s.indexOf('75') == 0) {

			this.com.townnews.BLOXTotalCMS.host.versionPointer_s = String(this.com.townnews.BLOXTotalCMS.host.versionPointer_n + '.' + String(this.com.townnews.BLOXTotalCMS.host.av).split('.')[ 2 ]);
			//-- 5.20.34.2018.09.11 INDESIGN-850 make the numeric version
			this.com.townnews.BLOXTotalCMS.host.versionPointer_n = Number(this.com.townnews.BLOXTotalCMS.host.versionPointer_s);
			//-- 5.20.10.2017.07.06 INDESIGN-1821 if we are here, then this is
			//--	definitely a CS 5 version. The if later will accept this
			//--	as a result.
			this.com.townnews.BLOXTotalCMS.host.isCS5 = true;
			//-- 5.37.11.2019.07.09 INDESIGN-2585 add extra tag for CS 5.5
			//--	because we need it to locate the keyboard shortcuts
			//--	and some other user settings
			this.com.townnews.BLOXTotalCMS.host.isCS_5_5 = true;

		}

		this.com.townnews.BLOXTotalCMS.host.AdobeApplicationVersion_s = this.com.townnews.BLOXTotalCMS.host.versionObject[ this.com.townnews.BLOXTotalCMS.host.versionPointer_s ];

		if (this.com.townnews.BLOXTotalCMS.host.AdobeApplicationVersion_s == undefined) {

			throw "Array doesn't contain the proper number for this version: '" + this.com.townnews.BLOXTotalCMS.host.versionPointer_s + "'";

		}

	} catch (err) {

		this.com.townnews.BLOXTotalCMS.localError = err;

		debugger;

		this.com.townnews.BLOXTotalCMS.host.AdobeApplicationVersion_s = 'CC+';

	}

	//-- 5.54.01.2021.10.26 if the version has reached CC 2023 or greater
	//--	then configure a global for the use of Parent Page versus
	//--	Master Page to use 'Inclusive Language' in version CC 2023
	//-- 5.66.00-31.2023.09.29 INDESIGN-4158 When a version
	//--	doesn't have support in the version list in this .jsx file, the
	//--	following will error. Add protection and then assume Parent Page
	try {

		this.com.townnews.BLOXTotalCMS.host.inclusivePageName_s = (parseInt(this.com.townnews.BLOXTotalCMS.host.av.split('.')[ 0 ], 10) >= 17) ? 'Parent Page' : 'Master Page';

	} catch (err) {

		this.com.townnews.BLOXTotalCMS.host.inclusivePageName_s = 'Parent Page';

		this.com.townnews.BLOXTotalCMS.localError = err;

		debugger;

	}


	//-- 5.16.11.2016.12.30 INDESIGN-1548 setup a warning about bad versions
	//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
	this.com.townnews.BLOXTotalCMS.host.unsupportedVersions = {};

	with (this.com.townnews.BLOXTotalCMS.host) {

		//-- CS 4
		unsupportedVersions[ "60" ] = [ 'This version of the ' + app.name + ' software is too old.', 'It is not supported by the BLOX Total CMS client.', 'You must upgrade.', 'Creative Cloud is needed to support all features.' ];

		//-- CS 5.5 but not the unupdated versions
		unsupportedVersions[ "75.0" ] = unsupportedVersions[ "75.1" ] = unsupportedVersions[ "75.2" ] = [ 'This version of the ' + app.name + ' software NEEDS to be updated.', 'The only stable version of CS 5.5 is the final update known has 7.5.3.', 'In addition, Adobe no longer provides any support for Creative Suite CS 5 nor CS 5.5.', 'The Creative Cloud version of ' + app.name + ' is needed to support all BLOX Total CMS features.' ];

		//-- Original CS 6
		unsupportedVersions[ "80" ] = [ 'This is an UN-updated version of ' + app.name + ' CS 6.', 'It is known to be buggy and prone to crashing.', 'Please upgrade to the free CS 6.1 or subscribe to Adobe Creative Cloud.', 'Adobe Creative Cloud is needed to support all features.' ];

		//-- Broke versions of CC 2015
		unsupportedVersions[ "114" ] = [ app.name + ' Creative Cloud 2015 versions .4 and .5 are not supported by BLOX Total CMS.', 'It is known to be buggy and prone to crashing.', 'Please upgrade to the current version of Creative Cloud.' ];
		unsupportedVersions[ "115" ] = [ app.name + ' Creative Cloud 2015 versions .4 and .5 are not supported by BLOX Total CMS.', 'It is known to be buggy and prone to crashing.', 'Please upgrade to the current version of Creative Cloud.' ];

		//-- 5.20.03.2017.06.21 no ticket. Also warn about the .1 version
		//--	being prone to crashing during quitting
		unsupportedVersions[ "121" ] = [ app.name + ' Creative Cloud 2017 versions .1 are not recommended.', 'It is known to be prone to crashing when quitting.', 'Please downgrade to the original version of Creative Cloud 2017 or upgrade to something newer than .1 if it exists.' ];

	}
	//-- 4.71.26.2013.04.17 adding new flag for CS 5 for hiding progress bars.
	//-- 5.10.04.2015.01.28 INDESIGN-396 CS 5.5 should also be considered a CS 5 version.
	//-- 5.20.31.2017.09.06 INDESIGN-1821 CS 5.5 isn't getting pulled here
	//--	Change the formula for determining what is what.
	//-- 5.20.34.2018.09.11 INDESIGN-850 have this use the string versionPointer
	this.com.townnews.BLOXTotalCMS.host.isCS5 = this.com.townnews.BLOXTotalCMS.host.isCS5 || (this.com.townnews.BLOXTotalCMS.host.AdobeApplicationVersion_s.indexOf('CS 5') > -1) || (this.com.townnews.BLOXTotalCMS.host.versionPointer_s.substring(0, 1) == "75");

	//-- 4.71.67.2013.07.09 in Tucson, AZ asking for a CC version as well
	this.com.townnews.BLOXTotalCMS.host.isCC = (this.com.townnews.BLOXTotalCMS.host.AdobeApplicationVersion_s.indexOf('CC') >= 0);

	//-- 4.72.43.2014.01.20 set a version flag for prior to 9.2 when
	//--	Adobe changed the UI preference for white UI
	//-- 5.17.04.2017.01.09 Noticed that the check below was textural and it
	//--	should instead have been numerical
	//-- 5.20.34.2018.09.11 INDESIGN-850 again, this will use the string version
	this.com.townnews.BLOXTotalCMS.host.isCC_LessThanCC_2 = this.com.townnews.BLOXTotalCMS.host.isCC && ((this.com.townnews.BLOXTotalCMS.host.versionPointer_s == "90") || (this.com.townnews.BLOXTotalCMS.host.versionPointer_s == "91"));

	//-- 5.17.04.2017.01.09 INDESIGN-1560 Need a new flag for CC2017 and newer
	//--	to enabled Track Changes
	//-- 5.20.34.2018.09.11 INDESIGN-850 this has to use the numeric version
	this.com.townnews.BLOXTotalCMS.host.isCC_2017_orNewer_b = (this.com.townnews.BLOXTotalCMS.host.versionPointer_n >= 120);

	//-- 5.20.03.2017.06.21 INDESIGN-850 Adobe InDesign CC2015 broke the
	//--	iconButton titles. They can me mimicked with just plane static
	//--	text, but we need a flag to know when that has happened.
	//-- 5.20.34.2018.09.11 INDESIGN-850 another for the numeric version
	this.com.townnews.BLOXTotalCMS.host.iconButtonTitlesUnsupported_b = (this.com.townnews.BLOXTotalCMS.host.versionPointer_n >= 110);

	//-- 5.26.02.2018.02.02 INDESIGN-2047 noticed that this can have a
	//--	trailing space Also moving up so we don't have to call $.os
	//--	as often
	this.com.townnews.BLOXTotalCMS.host.st3 = ($.os).replace(/\s\s*$/, '');

	//-- 5.26.02.2018.02.02 INDESIGN-2047 switch $.os to .st3
	this.com.townnews.BLOXTotalCMS.host.fullName = app.name + ' ' + this.com.townnews.BLOXTotalCMS.host.AdobeApplicationVersion_s + '/' + this.com.townnews.BLOXTotalCMS.host.av + ' running under ' + this.com.townnews.BLOXTotalCMS.host.st3;

	//-- 4.71.95e.2014.01.10 make an even shorter version
	//-- 5.26.02.2018.02.02 INDESIGN-2047 switch $.os to .st3
	this.com.townnews.BLOXTotalCMS.host.shortName = app.name + ' ' + this.com.townnews.BLOXTotalCMS.host.AdobeApplicationVersion_s + '/' + this.com.townnews.BLOXTotalCMS.host.av + ' on ' + this.com.townnews.BLOXTotalCMS.host.st3;

	//-- 5.21.04.2017.10.03 INDESIGN-1912 add some more options
	this.com.townnews.BLOXTotalCMS.host.st2 = app.name + ' ' + this.com.townnews.BLOXTotalCMS.host.AdobeApplicationVersion_s + '/' + this.com.townnews.BLOXTotalCMS.host.av;

	this.com.townnews.BLOXTotalCMS.host.isInDesign = new RegExp('InDesign', 'i').test(app.name);
	this.com.townnews.BLOXTotalCMS.host.isInCopy = new RegExp('InCopy', 'i').test(app.name);
	this.com.townnews.BLOXTotalCMS.host.isWindows = new RegExp('Windows', 'i').test($.os);
	//-- 5.10.04.2015.01.26 JIRA INDESIGN-155 specifically let us know if this is windows 7
	this.com.townnews.BLOXTotalCMS.host.isWindows7 = new RegExp('Windows 7', 'i').test($.os);
	this.com.townnews.BLOXTotalCMS.host.isWindowsXP = new RegExp('Windows XP', 'i').test($.os);

	//-- 5.15.24.2016.09.02 INDESIGN-1071 Add three new options, 1st for CURL
	this.com.townnews.BLOXTotalCMS.host.isWindows8 = new RegExp('Windows 8', 'i').test($.os);
	this.com.townnews.BLOXTotalCMS.host.isWindows10 = new RegExp('Windows 10', 'i').test($.os);

	//-- 5.51.01.2021.04.27 INDESIGN-3241 All another option for Windows Server 2012
	this.com.townnews.BLOXTotalCMS.host.isWindowsServer2012 = new RegExp('Windows Server 2012', 'i').test($.os);

	//-- 5.15.26.2016.09.22 INDESIGN-1250 if this is any Windows install and
	//--	the path to the application includes (x86) then assume this is a
	//--	32bit install for CURL library
	this.com.townnews.BLOXTotalCMS.host.isWindows32Bit = false;
	this.com.townnews.BLOXTotalCMS.host.isWindows64Bit = false;
	if (this.com.townnews.BLOXTotalCMS.host.isWindows) {

		if (this.com.townnews.BLOXTotalCMS.host.isCS5 || (decodeURIComponent(app.filePath.fsName).indexOf('(x86)') > -1)) {

			this.com.townnews.BLOXTotalCMS.host.isWindows32Bit = true;

		} else if ($.os.indexOf("64") > 0) {

			this.com.townnews.BLOXTotalCMS.host.isWindows64Bit = true;

		}
	}
	//-- 4.40.8, change host tag to .isMacOS from .isMacintosh
	this.com.townnews.BLOXTotalCMS.host.isMacOS = (new RegExp('Macintosh', 'i').test($.os)) || (new RegExp('Mac\\s*OS', 'i').test($.os));

	//-- 5.57.00.2022.02.01 INDESIGN-3573 check to see if this is Monterey
	//--	which the initial versions had a bug with the menus. The user
	//--	needed to use both mouse buttons to get the menu to open. And
	//--	then use some oddness to get individual options to work.
	this.com.townnews.BLOXTotalCMS.host.isMacOSMonterey_b = /OS 12\./.test(this.com.townnews.BLOXTotalCMS.host.st3);

	//-- Version 3.70, add machine login information
	//-- 4.71.38.2013.05.14, adding protection on all of theses ;
	try {

		this.com.townnews.BLOXTotalCMS.host.machineLoginName = Folder.myDocuments.parent.displayName;

	} catch (err) {

		this.com.townnews.BLOXTotalCMS.localError = err;
		this.com.townnews.BLOXTotalCMS.host.machineLoginName = 'error_produced_default_machineLoginName';

	}

	try {

		//-- 5.44.09.2020.10.16 INDESIGN-3014 Add a new option for MacOS 
		//--	Machine Name. Thanks for Jim McKee for finding that method.
		//-- 5.53.16.2021.09.15 INDESIGN-3329 found where this 'hostname' on
		//--	MacOS changed with VPN access and so am converting to the
		//--	serial number for MacOS.
		// this.com.townnews.BLOXTotalCMS.host.machineName = this.com.townnews.BLOXTotalCMS.host.isMacOS ? app.doScript('do shell script "hostname"', ScriptLanguage.APPLESCRIPT_LANGUAGE).replace('.local', '') : $.getenv('COMPUTERNAME');
		this.com.townnews.BLOXTotalCMS.host.machineName = this.com.townnews.BLOXTotalCMS.host.isMacOS ? app.doScript('do shell script "ioreg -l | grep IOPlatformSerialNumber"', ScriptLanguage.APPLESCRIPT_LANGUAGE).split('=')[ 1 ].replace(/\W/g, '') : $.getenv('COMPUTERNAME');

	} catch (err) {

		this.com.townnews.BLOXTotalCMS.localError = err;
		this.com.townnews.BLOXTotalCMS.host.machineName = 'error_produced_default_machineName';

	}

	try {

		this.com.townnews.BLOXTotalCMS.host.machineDomainName = $.getenv('USERDOMAIN');


	} catch (err) {

		this.com.townnews.BLOXTotalCMS.localError = err;
		this.com.townnews.BLOXTotalCMS.host.machineDomainName = 'error_produced_default_machineDomainName';

	}

	//-- 4.71.52.2013.06.06, adding another host property because it
	//--	will show up in the revision files
	this.com.townnews.BLOXTotalCMS.host.scriptVersion = this.com.townnews.BLOXTotalCMS.scriptVersion.replace(new RegExp('\\.', 'g'), '_');

	//-- 5.16.06.2016.12.02 INDESIGN-1522 add a build numbers
	this.com.townnews.BLOXTotalCMS.host.scriptBuildNumber = this.com.townnews.BLOXTotalCMS.scriptBuildNumber;
	this.com.townnews.BLOXTotalCMS.host.scriptVersionNumberWithBuild = this.com.townnews.BLOXTotalCMS.host.scriptVersion + '-' + this.com.townnews.BLOXTotalCMS.host.scriptBuildNumber;

	//-- 4.71.93c.2013.11.14 adding a host for revision files that is shorter
	//-- 4.71.95e.2014.01.10 shorten this more.
	//-- 5.16.06.2016.12.02 INDESIGN-1522 add a build value
	this.com.townnews.BLOXTotalCMS.hostForRevisionFiles = { app: this.com.townnews.BLOXTotalCMS.host.shortName, v: this.com.townnews.BLOXTotalCMS.host.scriptVersion, b: this.com.townnews.BLOXTotalCMS.host.scriptBuildNumber };

	//-- 4.21 add a launch variable to keep the global namespace cleaner.
	//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
	//-- 5.43.02.2020.04.06 INDESIGN-2766
	if (!this.com.townnews.BLOXTotalCMS.hasOwnProperty('launch')) {

		this.com.townnews.BLOXTotalCMS.launch = {};

		//-- 5.46.04.2020.12.29 INDESIGN-3013 add a default option
		//--	for the servers.jsx file which is used for auto 
		//--	creating a servers.jsx. false is default option.
		this.com.townnews.BLOXTotalCMS.launch.noServersJSX_b = false;

	}

	//-- 4.31.0 add a paremeter for login inforation
	//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
	this.com.townnews.BLOXTotalCMS.login = {};
	//-- Below is a flag for revised versus original login code.
	this.com.townnews.BLOXTotalCMS.login.method = true;

	//-- 5.43.02.2020.04.06 INDESIGN-2766 use tac_login by default
	//--	This switches the dialog that is used. It does NOT 
	//--	determine if the access code is shown or not. When 
	//--	false, we use LEGACY dialog. When True we use new 
	//--	dialog. 
	this.com.townnews.BLOXTotalCMS.login.tac_login_b = true;

	//------------------------------------------
	//-- R E S O U R C E   M A N A G E M E N T
	//------------------------------------------

	//-- 4.21 Find this file
	//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
	this.com.townnews.BLOXTotalCMS.resources = {};
	this.com.townnews.BLOXTotalCMS.resources.rootScriptPath = locateRootScriptPath();

	//-- 5.18.01-1.2017.02.15 INDESIGN-1566 if that includes the
	//--	"tcms_indesign_client" share, then switch to the "tcms_data" share.
	//--	Different options exists when developing code
	this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d = this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.parent;
	this.com.townnews.BLOXTotalCMS.resources.rootScriptPath_original_s = this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.toString();
	this.com.townnews.BLOXTotalCMS.resources.runningFromPacManInstall_b = false;
	this.com.townnews.BLOXTotalCMS.launch.remoteLaunchShare = 'tcms_indesign_client';
	// if ($.level > 0) {
	// 	if (this.com.townnews.BLOXTotalCMS.host.isInDesign && this.com.townnews.BLOXTotalCMS.host.isCC && this.com.townnews.BLOXTotalCMS.host.isMacOS) {

	// 		//-- edit this to convince it to match
	// 		this.com.townnews.BLOXTotalCMS.launch.remoteLaunchShare = 'tcms-indesign-client'
	// 	}
	// 	else {
	// 		this.com.townnews.BLOXTotalCMS.launch.remoteLaunchShare = 'test_client';
	// 	}
	// }
	this.com.townnews.BLOXTotalCMS.launch.positionOfRemoteLaunchShare_i = this.com.townnews.BLOXTotalCMS.resources.rootScriptPath_original_s.indexOf(this.com.townnews.BLOXTotalCMS.launch.remoteLaunchShare);

	if (this.com.townnews.BLOXTotalCMS.launch.positionOfRemoteLaunchShare_i > -1) {

		this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d = Folder(this.com.townnews.BLOXTotalCMS.resources.rootScriptPath_original_s.substr(0, this.com.townnews.BLOXTotalCMS.launch.positionOfRemoteLaunchShare_i) + 'tcms_data');
		if (!this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d.exists) {

			//-- 5.53.15.2021.09.13 INDESIGN-3439 set die to true
			this.com.townnews.BLOXTotalCMS.launch.triedToDie_b = true;


			die('Can NOT reach the expected root script path when loading from an appliance release.\n\nExpected path is:\n   ' + decodeURIComponent(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d.fsName));

			debugger;

		}

		this.com.townnews.BLOXTotalCMS.resources.runningFromPacManInstall_b = true;

	}
	// else if (($.level > 0) && this.com.townnews.BLOXTotalCMS.host.isInDesign && this.com.townnews.BLOXTotalCMS.host.isCC && this.com.townnews.BLOXTotalCMS.host.isMacOS) {

	// 	//manually redirect here
	// 	this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d = Folder('~/tcms/tcms_data');
	// 	if (!this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d.exists) {

	// 		die('Can NOT reach the expected root script path when loading from an appliance release.\n\nExpected path is:\n   ' + decodeURIComponent(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d.fsName));

	// 	}
	// 	this.com.townnews.BLOXTotalCMS.resources.runningFromPacManInstall_b = true;
	// }


	//-- 5.53.15.2021.09.13 INDESIGN-3439 check for permission to continue
	if (!this.com.townnews.BLOXTotalCMS.launch.triedToDie_b) {

		//------------------------
		//-- U S E R   A G E N T
		//------------------------
		//-- 5.26.02.2018.02.02 INDESIGN-2047 creating the User-Agent code based
		//--	on this formula:
		//--	host app/host app version (os and version) c/clientversion source
		//--	where 'source' is A for tcms_indesign_client based else L for some
		//--	sort of localized install.
		this.com.townnews.BLOXTotalCMS.host.user_agent = (this.com.townnews.BLOXTotalCMS.host.isInDesign ? 'ID/' : 'IC/') + this.com.townnews.BLOXTotalCMS.host.av + ' (' + (this.com.townnews.BLOXTotalCMS.host.st3).replace('Windows', 'W').replace('Macintosh', 'M').replace('Service Pack', 'sp') + ') c/' + this.com.townnews.BLOXTotalCMS.host.scriptVersionNumberWithBuild + (this.com.townnews.BLOXTotalCMS.resources.runningFromPacManInstall_b ? ' A' : ' L');


		//------------------------------------------------
		//-- V E R S I O N   A N D   H O S T   F I L E S
		//------------------------------------------------
		//-- 4.42.01, Add support for writing out the version
		//-- 4.66.05, 2012.06.08, make the file a .version so that the
		//--	CVS knows what it is.
		//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
		//~ 	this.com.townnews.BLOXTotalCMS.resources.versionFileRef = File (this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.parent + '/' + this.com.townnews.BLOXTotalCMS.scriptVersion.replace (new RegExp ('\\.','g'), '_') + '.version') ;
		this.com.townnews.BLOXTotalCMS.resources.versionFileRef = File(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d + '/' + this.com.townnews.BLOXTotalCMS.scriptVersion.replace(new RegExp('\\.', 'g'), '_') + '.version');
		if (!this.com.townnews.BLOXTotalCMS.resources.versionFileRef.exists) {

			try {

				this.com.townnews.BLOXTotalCMS.resources.versionFileRef.open('w');
				this.com.townnews.BLOXTotalCMS.resources.versionFileRef.close();

			} catch (err) {

				this.com.townnews.BLOXTotalCMS.localError = err;

			}
		}
		//-- 4.71.52.2013.06.06, add support for writing out .host files so
		//--	that the logs can know if they need to sort the files. Basically
		//--	if there is two .application files, sorting will happen.
		//-- 4.71.52.2013.06.06, write this application.
		//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
		this.com.townnews.BLOXTotalCMS.resources.hostFileRef = File(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d + '/' + app.name.replace(new RegExp('( \\.)', 'g'), '_') + '.host');
		if (!this.com.townnews.BLOXTotalCMS.resources.hostFileRef.exists) {

			try {

				this.com.townnews.BLOXTotalCMS.resources.hostFileRef.open('w');
				this.com.townnews.BLOXTotalCMS.resources.hostFileRef.close();

			} catch (err) {

				this.com.townnews.BLOXTotalCMS.localError = err;

			}
		}

		//-- 4.71.52.2013.06.06, count the number of host applications
		//-- 4.71.52.2013.06.06, set the flag if more than 1
		//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
		this.com.townnews.BLOXTotalCMS.resources.multipleHosts = (this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d.getFilesWithSuffix('.host').length > 1);

		//-- Add an object for the loaded files.
		//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
		this.com.townnews.BLOXTotalCMS.resources.loaded = {};

		//-- then the resources
		//-- 4.31.1 rename to lower case
		this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server = new Folder(this.com.townnews.BLOXTotalCMS.resources.rootScriptPath + '/resources');


		//---------------------------------------------------------------------
		//-- E N A B L E D   &   D I S A B L E D
		//---------------------------------------------------------------------
		//-- 4.71.05.2013.03.11 look for all enabled and disabled files
		//--	and store those files
		//-- Create an array of file extensions. Then those will be looped
		this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions = [ 'disabled', 'enabled' ];
		//-- loop through each file extension
		for (this.com.townnews.BLOXTotalCMS.launch.fi = 0; this.com.townnews.BLOXTotalCMS.launch.fi < this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions.length; this.com.townnews.BLOXTotalCMS.launch.fi++) {

			//-- Ad the file extension object if it doesn't exist
			if (!this.com.townnews.BLOXTotalCMS.resources.hasOwnProperty(this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ])) {

				//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
				this.com.townnews.BLOXTotalCMS.resources[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] ] = {};

			}
			//-- Get all the files with that extension and store them in
			//--	a variable using the extension name.
			//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
			//~ 			this.com.townnews.BLOXTotalCMS.launch [ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[this.com.townnews.BLOXTotalCMS.launch.fi] + 'Files' ] = Folder (this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.parent).getFilesWithSuffix ('.' + this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[this.com.townnews.BLOXTotalCMS.launch.fi]) ;
			this.com.townnews.BLOXTotalCMS.launch[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] + 'Files' ] = Folder(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d).getFilesWithSuffix('.' + this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ]);

			//-- loop through each found file so make an associative array
			//--	with each main file name
			for (this.com.townnews.BLOXTotalCMS.launch.si = 0; this.com.townnews.BLOXTotalCMS.launch.si < this.com.townnews.BLOXTotalCMS.launch[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] + 'Files' ].length; this.com.townnews.BLOXTotalCMS.launch.si++) {

				if (!this.com.townnews.BLOXTotalCMS.resources[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] ].hasOwnProperty(this.com.townnews.BLOXTotalCMS.launch[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] + 'Files' ][ this.com.townnews.BLOXTotalCMS.launch.si ].nameWithoutExtension())) {

					this.com.townnews.BLOXTotalCMS.resources[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] ][ this.com.townnews.BLOXTotalCMS.launch[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] + 'Files' ][ this.com.townnews.BLOXTotalCMS.launch.si ].nameWithoutExtension() ] = true;

					//-- 4.71.07.2013.03.12 also log them in the loaded files
					this.com.townnews.BLOXTotalCMS.resources.loaded[ this.com.townnews.BLOXTotalCMS.launch[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] + 'Files' ][ this.com.townnews.BLOXTotalCMS.launch.si ].name ] = this.com.townnews.BLOXTotalCMS.launch[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] + 'Files' ][ this.com.townnews.BLOXTotalCMS.launch.si ];

				}
			}
		}

		//------------------------------------------------
		//-- L O C A L   R E S O U R C E S   F O L D E R
		//------------------------------------------------
		//-- 5.29.01.2018.03.17 INDESIGN-2110 If the host is MacOS and if a special
		//--	enabled file exists then allow the local resources folder to be
		//--	placed in the user's home folder rather than the User Data folder
		//--	as it normally is.
		//-- This is triggered by the presence of a file named 'MacOS_homeFolder.enabled'
		if (this.com.townnews.BLOXTotalCMS.host.isMacOS && this.com.townnews.BLOXTotalCMS.resources.enabled.hasOwnProperty('MacOS_homeFolder')) {

			this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local = new Folder('~/BLOX Total CMS/resources');
			//-----------------------------------------------------------------
			//-- N O T E:
			//-- 5.67.00-4.2023.12.20 INDESIGN-4134 while testing this, found a case where _my_ home folder has a folder alias named `BLOX Total CMS` that pointed to the one in the Library folder. And I would then get an error when it was first accessed (down at the logo area). For, reasons I don't understand, the .verify() method below did NOT fail!
			//-----------------------------------------------------------------

		} else {

			//-- This is the normal location for all users except those above
			//-- 4.57.02, 2012.01.30, construct local copies
			this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local = new Folder(Folder.userData + '/BLOX Total CMS/resources');

		}
		if (!this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local.verify()) {

			die('The local \'resources\' folder does not exist at: \'' + decodeURIComponent(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local) + '\' and launch cannot continue.');

		}

	}


	//---------------------------------------------
	//-- H A R D   C O D E D   R E S O U R C E S
	//---------------------------------------------
	if (!this.com.townnews.BLOXTotalCMS.launch.triedToDie_b) {

		//-- Load all the hard coded resources
		//-- The flash file the handles the JSON encoding
		//-- 4.31.1 rename to lower case
		//-- 4.57.02, 2012.01.30, copy then load
		//-- 5.46.01.2020.12.23 INDESIGN-3107 do not do this for Creative Cloud users
		if (!this.com.townnews.BLOXTotalCMS.host.isCC) {

			//--------------------------------------------------------------
			//-- F L A S H   F I L E   F O R   C R E A T I V E   S U I T E
			//--------------------------------------------------------------
			this.com.townnews.BLOXTotalCMS.resources.JSONflashFile = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local + '/tcms.swf');
			if (!File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/tcms.swf').copy(this.com.townnews.BLOXTotalCMS.resources.JSONflashFile)) {

				//-- 4.66.12, 2012.06.21 typo fix
				die('Unable to create a local copy of the \'tcms.swf\' file. The BLOX Total CMS launch sequence cannot continue.');

			}
		}
	}

	//-- 5.53.15.2021.09.13 INDESIGN-3439 check flag, do this section if false
	if (!this.com.townnews.BLOXTotalCMS.launch.triedToDie_b) {

		//-- 4.33, skip this if stand alone AdMarket Install
		//-- 4.65.25, 2012.05.30 also handle standalone ad owl
		//-- 5.15.24.2016.09.07 INDESIGN-1230 remove Ad Market and Ad Owl
		//-- 5.14.67.2016.10.04 INDESIGN-1263, load the logo file again.
		//-- 5.67.00-4.2023.12.20 INDESIGN-4134 remove the reference to the old logo and the date switch
		// var logoImageFileName_s = 'blox-total-cms-logo.png';
		// if (new Date() >= new Date(2023, 1, 3, 0, 0, 0, 0)) {
		var logoImageFileName_s = 'BLOX-Total-CMS-vertical-135x51.png';
		// }

		//-- 5.67.00-4.2023.12.20 INDESIGN-4134 for Creative Cloud users, this becomes the first place of failure if the resourcesFolder_Local
		this.com.townnews.BLOXTotalCMS.resources.logoImage = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local + '/' + logoImageFileName_s);
		if (!File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/' + logoImageFileName_s).copy(this.com.townnews.BLOXTotalCMS.resources.logoImage)) {

			//-- 4.66.12, 2012.06.21 typo fix
			die('Unable to create a local copy of the \'' + logoImageFileName_s + '\' file. The BLOX Total CMS launch sequence can not continue.');

		}

	}

	//-- 5.53.15.2021.09.13 INDESIGN-3439 check flag, do this section if false
	if (!this.com.townnews.BLOXTotalCMS.launch.triedToDie_b) {

		//--------------------------------------------
		//-- P A G E   T R A C K E R   P R E V I E W
		//--------------------------------------------
		//-- 5.13.03.2016.02.01 INDESIGN-923 check to see if the preset for PDF
		//--	previews for Page Tracker exists
		this.com.townnews.BLOXTotalCMS.resources.PageTrackerPreview = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local + '/PageTrackerPreview.joboptions');
		if (!File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/PageTrackerPreview.joboptions').copy(this.com.townnews.BLOXTotalCMS.resources.PageTrackerPreview)) {

			//-- 5.53.01.2021.06.15 INDESIGN-3303 modify the failure. This
			//--	originally used die, but that doesn't seem to work.
			this.com.townnews.BLOXTotalCMS.localError = {};
			this.com.townnews.BLOXTotalCMS.localError.loadCodeMessage_s = 'Unable to create a local copy of the \'PageTrackerPreview.joboptions\' file. The BLOX Total CMS launch sequence cannot continue.';

			throw (this.com.townnews.BLOXTotalCMS.localError);

		}

		//--------------
		//-- I C O N S
		//--------------
		//-- 4.39.2, move all icons to an icons directory
		//-- 4.57.02, make that a local directory
		this.com.townnews.BLOXTotalCMS.resources.iconsFolder = Folder(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/icons/');
		if (!this.com.townnews.BLOXTotalCMS.resources.iconsFolder.exists) {

			die('The \'icons\' folder does not exists at: \'' + decodeURIComponent(this.com.townnews.BLOXTotalCMS.resources.iconsFolder) + '\' and launch cannot continue.');

		} else {

			//-- Load the icons. Revised setup on 2012.01.30
			//--	for version 4.57.02 to work from local copies.
			//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
			this.com.townnews.BLOXTotalCMS.resources.icons = {};

			//-- 4.40.8 change to the way 'getFiles' is used
			this.com.townnews.BLOXTotalCMS.resources.allIconFiles_Server = this.com.townnews.BLOXTotalCMS.resources.iconsFolder.getFilesWithSuffix('.png');
			//-- loop through the found files
			for (this.com.townnews.BLOXTotalCMS.launch.iconI = this.com.townnews.BLOXTotalCMS.resources.allIconFiles_Server.length - 1; this.com.townnews.BLOXTotalCMS.launch.iconI >= 0; this.com.townnews.BLOXTotalCMS.launch.iconI--) {

				//-- create a temporary variable to speed things along
				this.com.townnews.BLOXTotalCMS.launch.iconName = this.com.townnews.BLOXTotalCMS.resources.allIconFiles_Server[ this.com.townnews.BLOXTotalCMS.launch.iconI ].nameWithoutExtension();

				this.com.townnews.BLOXTotalCMS.resources.icons[ this.com.townnews.BLOXTotalCMS.launch.iconName ] = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local + '/' + this.com.townnews.BLOXTotalCMS.launch.iconName + '.png');
				if (!this.com.townnews.BLOXTotalCMS.resources.allIconFiles_Server[ this.com.townnews.BLOXTotalCMS.launch.iconI ].copy(this.com.townnews.BLOXTotalCMS.resources.icons[ this.com.townnews.BLOXTotalCMS.launch.iconName ])) {

					die('Unable to successfully copy the \'' + this.com.townnews.BLOXTotalCMS.launch.iconName + '\' to: \'' + decodeURIComponent(this.com.townnews.BLOXTotalCMS.resources.icons[ this.com.townnews.BLOXTotalCMS.launch.iconName ].fsName));

				}
			}

			//--------------------------------------
			//-- T R U E   F A L S E   I M A G E S
			//--------------------------------------
			//-- 5.53.15.2021.09.13 INDESIGN-3439 check flag, do this section if false
			if (!this.com.townnews.BLOXTotalCMS.launch.triedToDie_b) {

				//-- These two legacy icons are special. Revised setup on 2012.01.30
				//--	for version 4.57.02 to work from local copies.
				this.com.townnews.BLOXTotalCMS.resources.falseImage = this.com.townnews.BLOXTotalCMS.resources.icons[ 'false' ];
				this.com.townnews.BLOXTotalCMS.resources.trueImage = this.com.townnews.BLOXTotalCMS.resources.icons[ 'true' ];

			}
		}
	}

	//-- 5.53.15.2021.09.13 INDESIGN-3439 check flag, do this section if false
	if (!this.com.townnews.BLOXTotalCMS.launch.triedToDie_b) {

		//-- Verify that the Resources folder exists
		if (!this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server.exists) {

			//-- Yes, it is somewhat out of order to finally check for this now,
			//--	but it will work fine.
			die('Resources folder not found');

		} else if ((!this.com.townnews.BLOXTotalCMS.host.isCC) && (!this.com.townnews.BLOXTotalCMS.resources.JSONflashFile.exists)) {

			//-- 5.46.01.2020.12.23 INDESIGN-3107 Changed the above if to only
			//--	search for the .swf file when this is NOT a Creative Cloud
			//--	version of Adobe InCopy or Adobe InDesign

			//--------------------------------------------------------------
			//-- F L A S H   F I L E   F O R   C R E A T I V E   S U I T E
			//--------------------------------------------------------------

			die('Flash file for JSON encoding does not exist.\n\nExpected at:\n   ' + decodeURIComponent(this.com.townnews.BLOXTotalCMS.resources.JSONflashFile.fsName));

		} else {

			//-- Resources folder exists on Server
			//-- 5.12.57.2015.12.23 INDESIGN-866, check for a version file on the
			//--	server version.
			//-- 5.18.01-1.2017.02.15 INDESIGN-1566 if the code is loaded from a
			//--	PacMan install, then don't attempt to check for or create these
			//--	two files.
			if (this.com.townnews.BLOXTotalCMS.resources.runningFromPacManInstall_b === false) {

				this.com.townnews.BLOXTotalCMS.resources.serverVersionFileRef = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/' + this.com.townnews.BLOXTotalCMS.scriptVersion.replace(new RegExp('\\.', 'g'), '_') + '.version');

				if (!this.com.townnews.BLOXTotalCMS.resources.serverVersionFileRef.exists) {

					try {

						this.com.townnews.BLOXTotalCMS.resources.serverVersionFileRef.open('w');
						this.com.townnews.BLOXTotalCMS.resources.serverVersionFileRef.close();

					} catch (err) {

						this.com.townnews.BLOXTotalCMS.localError = err;

					}
				}
				//-- 5.16.06.2016.12.02 INDESIGN-1522 add a build file using the existing cleaned copy
				this.com.townnews.BLOXTotalCMS.resources.scriptVersionNumberWithBuildFileRef = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/' + this.com.townnews.BLOXTotalCMS.scriptVersionNumberWithBuild + '.build');
				if (!this.com.townnews.BLOXTotalCMS.resources.scriptVersionNumberWithBuildFileRef.exists) {

					try {

						//-- 5.49.03.2021.03.25 INDESIGN-3234 if the volume exists, then build the release folder
						if (($.level > 0) && this.com.townnews.BLOXTotalCMS.host.isInDesign && this.com.townnews.BLOXTotalCMS.host.isCC && this.com.townnews.BLOXTotalCMS.host.isMacOS && Folder('//volumes/Releases').exists) {

							// parts of the name
							this.com.townnews.BLOXTotalCMS.launch.scriptVersionParts_a = this.com.townnews.BLOXTotalCMS.scriptVersion.split('.');
							//-- outer group folder
							this.com.townnews.BLOXTotalCMS.launch.version_x_d = Folder('//volumes/Releases/' + this.com.townnews.BLOXTotalCMS.launch.scriptVersionParts_a[ 0 ] + '_' + this.com.townnews.BLOXTotalCMS.launch.scriptVersionParts_a[ 1 ] + '_x');

							if (this.com.townnews.BLOXTotalCMS.launch.version_x_d.verify()) {

								//-- inner folder
								this.com.townnews.BLOXTotalCMS.launch.version_complete_d = Folder(this.com.townnews.BLOXTotalCMS.launch.version_x_d + '/' + this.com.townnews.BLOXTotalCMS.launch.scriptVersionParts_a.join('_'));

								if (this.com.townnews.BLOXTotalCMS.launch.version_complete_d.verify()) {

									//-- code folder with build number
									Folder(this.com.townnews.BLOXTotalCMS.launch.version_complete_d + '/' + this.com.townnews.BLOXTotalCMS.scriptVersionNumberWithBuild.replace(/\./g, '_')).verify();

								}
							}
						}
						this.com.townnews.BLOXTotalCMS.resources.scriptVersionNumberWithBuildFileRef.open('w');
						this.com.townnews.BLOXTotalCMS.resources.scriptVersionNumberWithBuildFileRef.close();

					} catch (err) {

						this.com.townnews.BLOXTotalCMS.localError = err;
						debugger;

					}

				}
			}
			//-- 5.12.57.2015.12.23 INDESIGN-868 add a client version in an
			//--	activeClientFolderName.txt file. Only do this if the folder
			//--	name starts with blox total cms or ActiveVersion
			this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName = this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.name;

			//-- 5.12.67.2016.01.13 INDESIGN-887 change the regular expression to
			//--	limit more characters.
			//~ 		this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName_clean = this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName.toLowerCase ().replace (/(\W|\s|_|-)/gim, '') ;
			this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName_clean = this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName.toLowerCase().replace(/[^a-z]/gm, '');;

			//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
			//~ 		this.com.townnews.BLOXTotalCMS.resources.activeClientFolderNameFileRef = File (this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.parent + '/activeClientFolderName.txt') ;
			this.com.townnews.BLOXTotalCMS.resources.activeClientFolderNameFileRef = File(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d + '/activeClientFolderName.txt');
			if (this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName_clean.indexOf('activeversion') == 0) {

				try {

					this.com.townnews.BLOXTotalCMS.resources.activeClientFolderNameFileRef.remove();

				} catch (err) {

					this.com.townnews.BLOXTotalCMS.localError = err;

				}

			} else if ((this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName_clean.indexOf('bloxtotalcms') > -1) || (this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName_clean.indexOf('developmentversion') == 0)) {

				if (!this.com.townnews.BLOXTotalCMS.resources.activeClientFolderNameFileRef.exists) {

					//-- file doesn't exist. Create it
					try {

						this.com.townnews.BLOXTotalCMS.resources.activeClientFolderNameFileRef.open('w');
						this.com.townnews.BLOXTotalCMS.resources.activeClientFolderNameFileRef.write(this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName);
						this.com.townnews.BLOXTotalCMS.resources.activeClientFolderNameFileRef.close();

					} catch (err) {

						this.com.townnews.BLOXTotalCMS.localError = err;

					}
				}
			}

			//-- record the loaded files
			//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
			this.com.townnews.BLOXTotalCMS.resources.skipped = {};
			//-- 4.24 add a replaced
			//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
			this.com.townnews.BLOXTotalCMS.resources.replaced = {};


			//----------------------
			//-- L A N G U A G E S
			//----------------------
			this.com.townnews.BLOXTotalCMS.resources.languages_o = {};
			this.com.townnews.BLOXTotalCMS.resources.languages_o.folderServer_d = Folder(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/languages');
			if (this.com.townnews.BLOXTotalCMS.resources.languages_o.folderServer_d.exists) {

				this.com.townnews.BLOXTotalCMS.resources.languages_o.folderLocal_d = Folder(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local + '/languages');
				if (this.com.townnews.BLOXTotalCMS.resources.languages_o.folderLocal_d.verify()) {

					this.com.townnews.BLOXTotalCMS.resources.languages_o.files_a = this.com.townnews.BLOXTotalCMS.resources.languages_o.folderServer_d.getFiles();
					this.com.townnews.BLOXTotalCMS.resources.languages_o.numFiles_i = this.com.townnews.BLOXTotalCMS.resources.languages_o.files_a.length;

					for (this.com.townnews.BLOXTotalCMS.launch.fi = 0; this.com.townnews.BLOXTotalCMS.launch.fi < this.com.townnews.BLOXTotalCMS.resources.languages_o.numFiles_i; this.com.townnews.BLOXTotalCMS.launch.fi++) {

						this.com.townnews.BLOXTotalCMS.launch.languageServerFile_f = this.com.townnews.BLOXTotalCMS.resources.languages_o.files_a[ this.com.townnews.BLOXTotalCMS.launch.fi ]
						this.com.townnews.BLOXTotalCMS.launch.languageFileName_s = this.com.townnews.BLOXTotalCMS.launch.languageServerFile_f.name;

						//-- skip the .DS_Store file or any hidden files
						if (this.com.townnews.BLOXTotalCMS.launch.languageFileName_s.indexOf('.') == 0) {
							debugger;
							continue;

						}

						this.com.townnews.BLOXTotalCMS.launch.languageLocalFile_f = File(this.com.townnews.BLOXTotalCMS.resources.languages_o.folderLocal_d + '/' + this.com.townnews.BLOXTotalCMS.launch.languageFileName_s);

						if ((!this.com.townnews.BLOXTotalCMS.launch.languageLocalFile_f.exists) || (this.com.townnews.BLOXTotalCMS.launch.languageServerFile_f.modified > this.com.townnews.BLOXTotalCMS.launch.languageLocalFile_f.modified)) {

							//-- copy the file from the server to the local folder
							this.com.townnews.BLOXTotalCMS.launch.languageServerFile_f.copy(this.com.townnews.BLOXTotalCMS.launch.languageLocalFile_f);

						}

					}

				} else {

					die('Could not create the local languages folder. Can NOT continue.');

					debugger;

					app.quit();

				}

			} else {

				die('No language files found. Can NOT continue.');

				debugger;

				app.quit();

			}

			//----------------
			//-- J S X B I N
			//----------------
			//-- 4.24 don't load the jsx files if working in debug mode.
			if ($.level == 0) {

				//-- get all the .jsxbin files and load them.
				//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
				this.com.townnews.BLOXTotalCMS.resources.jsxbin = {};
				this.com.townnews.BLOXTotalCMS.resources.jsxbin.folder = new Folder(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/jsxbin');

				if (this.com.townnews.BLOXTotalCMS.resources.jsxbin.folder.exists) {

					//-- 4.22, set a static variable
					this.com.townnews.BLOXTotalCMS.resources.jsxbin.folderExists = true;
					//-- 4.40.8 change to the way 'getFiles' is used
					this.com.townnews.BLOXTotalCMS.resources.jsxbin.files = this.com.townnews.BLOXTotalCMS.resources.jsxbin.folder.getFilesWithSuffix(".jsxbin");
					if (this.com.townnews.BLOXTotalCMS.resources.jsxbin.files != null) {

						this.com.townnews.BLOXTotalCMS.resources.jsxbin.numFiles = this.com.townnews.BLOXTotalCMS.resources.jsxbin.files.length;

						//-- 5.36.24.2019.04.26 INDESIGN-2540 sort the names
						this.com.townnews.BLOXTotalCMS.resources.jsxbin.files = this.com.townnews.BLOXTotalCMS.resources.jsxbin.files.sort();

						//loop and load
						for (this.com.townnews.BLOXTotalCMS.launch.fi = 0; this.com.townnews.BLOXTotalCMS.launch.fi < this.com.townnews.BLOXTotalCMS.resources.jsxbin.files.length; this.com.townnews.BLOXTotalCMS.launch.fi++) {

							try {

								//-- Use doScript to read the file and execute it
								this.com.townnews.BLOXTotalCMS.launch.loadResult = app.doScript(this.com.townnews.BLOXTotalCMS.resources.jsxbin.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]);
								//-- Add the raw filename to the loaded files to prevent the
								//--	jsx version from loading later
								this.com.townnews.BLOXTotalCMS.resources.loaded[ File(this.com.townnews.BLOXTotalCMS.resources.jsxbin.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]).nameWithoutExtension() ] = this.com.townnews.BLOXTotalCMS.resources.jsxbin.files[ this.com.townnews.BLOXTotalCMS.launch.fi ];

							} catch (err) {

								this.com.townnews.BLOXTotalCMS.localError = err;

								this.com.townnews.BLOXTotalCMS.localError.loadCodeMessage_s = 'An error occurred loading: \'' + this.com.townnews.BLOXTotalCMS.resources.jsxbin.files[ this.com.townnews.BLOXTotalCMS.launch.fi ].nameWithoutExtension() + '.jsxbin\'\n\n' + err;

								throw (this.com.townnews.BLOXTotalCMS.localError);

							}
						}
					}
				}
			}

			//----------
			//-- J S X
			//----------
			//-- get all the .jsx files and load them.
			//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
			this.com.townnews.BLOXTotalCMS.resources.jsx = {};
			this.com.townnews.BLOXTotalCMS.resources.jsx.folder = new Folder(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/jsx');
			if (this.com.townnews.BLOXTotalCMS.resources.jsx.folder.exists) {

				//-- 4.40.8 change to the way 'getFiles' is used
				this.com.townnews.BLOXTotalCMS.resources.jsx.files = this.com.townnews.BLOXTotalCMS.resources.jsx.folder.getFilesWithSuffix(".jsx");

				if (this.com.townnews.BLOXTotalCMS.resources.jsx.files != null) {

					this.com.townnews.BLOXTotalCMS.resources.jsx.numFiles = this.com.townnews.BLOXTotalCMS.resources.jsx.files.length;

					//-- 5.36.24.2019.04.26 INDESIGN-2540 sort the names
					this.com.townnews.BLOXTotalCMS.resources.jsx.files = this.com.townnews.BLOXTotalCMS.resources.jsx.files.sort();

					//loop and load
					for (this.com.townnews.BLOXTotalCMS.launch.fi = 0; this.com.townnews.BLOXTotalCMS.launch.fi < this.com.townnews.BLOXTotalCMS.resources.jsx.files.length; this.com.townnews.BLOXTotalCMS.launch.fi++) {

						//-- 5.37.06.2019.06.11 INDESIGN-1951 wrap this in
						//--	try / catch to aid in development debugging
						//--	Need a way to see
						//--	the variable that has the script name.
						try {

							//-- skipping jsx versions if the jsxbin exists.
							this.com.townnews.BLOXTotalCMS.launch.jsxName = File(this.com.townnews.BLOXTotalCMS.resources.jsx.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]).nameWithoutExtension();

							//-- 4.22, if the file isn't loaded or if the
							//--	modification date of the .jsx is newer than the
							//--	modification date of the jsxbin, then load it.
							//-- 5.35.03.2018.12.17 no ticket. Change dev only launch
							//--	so that the JSX can be up to 1 second older to
							//--	deal with the way GIT updates things when
							//--	switching versions
							if ((!this.com.townnews.BLOXTotalCMS.resources.loaded.hasOwnProperty(this.com.townnews.BLOXTotalCMS.launch.jsxName)) || (this.com.townnews.BLOXTotalCMS.resources.jsxbin.folderExists && (this.com.townnews.BLOXTotalCMS.resources.jsx.files[ this.com.townnews.BLOXTotalCMS.launch.fi ].modified - File(this.com.townnews.BLOXTotalCMS.resources.jsxbin.folder + '/' + this.com.townnews.BLOXTotalCMS.launch.jsxName + '.jsxbin').modified > 1001))) {

								//-- Use doScript to read the file and execute it
								this.com.townnews.BLOXTotalCMS.launch.loadResult = app.doScript(this.com.townnews.BLOXTotalCMS.resources.jsx.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]);
								//-- 4.24 add the replaced listing
								if (this.com.townnews.BLOXTotalCMS.resources.loaded.hasOwnProperty(this.com.townnews.BLOXTotalCMS.launch.jsxName)) {

									//-- already loaded as a JSXBIN
									this.com.townnews.BLOXTotalCMS.resources.replaced[ this.com.townnews.BLOXTotalCMS.launch.jsxName ] = this.com.townnews.BLOXTotalCMS.resources.loaded[ this.com.townnews.BLOXTotalCMS.launch.jsxName ];

								}
								//-- Add the raw filename to the loaded files for
								//--	later logging.
								this.com.townnews.BLOXTotalCMS.resources.loaded[ this.com.townnews.BLOXTotalCMS.launch.jsxName ] = this.com.townnews.BLOXTotalCMS.resources.jsx.files[ this.com.townnews.BLOXTotalCMS.launch.fi ];
							}

						} catch (err) {

							//-- 5.50.01.2021.03.30 INDESIGN-3203 When a .jsx has a load
							//--	error, be more precise about which file had the issue.
							//-- Because of the use of '.loadCodeMessage_s' it should feed
							//--	a different error handler. 
							this.com.townnews.BLOXTotalCMS.localError = err;
							this.com.townnews.BLOXTotalCMS.localError.javascriptFileName_s = this.com.townnews.BLOXTotalCMS.launch.jsxName;

							this.com.townnews.BLOXTotalCMS.localError.loadCodeMessage_s = 'An error occurred loading: \'' + this.com.townnews.BLOXTotalCMS.localError.javascriptFileName_s + '.jsx\'\n\nThe error was ' + this.com.townnews.BLOXTotalCMS.localError.name + ': ' + this.com.townnews.BLOXTotalCMS.localError.message + '\n\nThe launch of the BLOX Total CMS client will halt.';

							throw (this.com.townnews.BLOXTotalCMS.localError);

						}
					}
				}
			}
			//-- Check that items were loaded
			if (this.com.townnews.BLOXTotalCMS.resources.loaded.toSource() == '({})') {

				die('No ExtendScript files loaded. Can NOT continue.');
				app.quit();

			} else {

				//-- Continue with the startup procedure ;

				//  define the JSON class object
				//-- Ideally this wouldn't be a globally exposed item.
				if (typeof (JSON) == "undefined") {

					//-- 4.71.67.2013.07.10 in Tucson, AZ, skip the SWF if this is CC
					if (this.com.townnews.BLOXTotalCMS.host.isCC) {

						JSON = new CreativeCloud_jsonClass();

					} else {

						//-- pre CC method
						JSON = new jsonClass(this.com.townnews.BLOXTotalCMS.resources.JSONflashFile);

					}
				}
			}

			//--------------------------------------------------------------------
			//-- S E R V E R S. J S X
			//--------------------------------------------------------------------
			//-- 5.53.15.2021.09.13 INDESIGN-3439 check flag, do this section if false
			if (!this.com.townnews.BLOXTotalCMS.launch.triedToDie_b) {

				//-- 5.36.24.2019.04.26 INDESIGN-2540, remove the check for ad Owl and asd Market
				//-- 4.25.11 load the servers file. Take the first one that is found
				this.com.townnews.BLOXTotalCMS.launch.userServers = File(Folder.userData + '/BLOX Total CMS/servers.jsx');

				//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
				this.com.townnews.BLOXTotalCMS.launch.serverServers = File(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d + '/servers.jsx');

				if (this.com.townnews.BLOXTotalCMS.launch.userServers.exists) {

					//-- 5.36.24.2019.04.26 INDESIGN-2540 protect this so that if the
					//--	servers file has language issues, login can proceed.
					try {

						//-- 5.42.21.2020.03.09 INDESIGN-2814 add a new item to allow
						//--	the logging of the loaded servers.jsx file.
						this.com.townnews.BLOXTotalCMS.launch.attemptedUserServers_b = true;

						this.com.townnews.BLOXTotalCMS.launch.loadResult = app.doScript(this.com.townnews.BLOXTotalCMS.launch.userServers);
						this.com.townnews.BLOXTotalCMS.resources.loaded[ this.com.townnews.BLOXTotalCMS.launch.userServers.name ] = this.com.townnews.BLOXTotalCMS.launch.userServers;

						this.com.townnews.BLOXTotalCMS.resources.servers = servers();
						//-- 5.42.21.2020.03.09 INDESIGN-2814 add a new item to allow
						//--	the logging of the loaded servers.jsx file.
						this.com.townnews.BLOXTotalCMS.launch.serversJSX_f = this.com.townnews.BLOXTotalCMS.launch.userServers;

					} catch (err) {

						//-- 5.36.25.2019.05.06 INDESIGN-2547 provide a way to watch
						this.com.townnews.BLOXTotalCMS.localError = err;

						//-- 5.42.21.2020.03.09 INDESIGN-2814 If this errored, clear
						//--	the value so that it will trigger a warning in
						//--	'startup_loginAndSetupMenusAndEvents'
						this.com.townnews.BLOXTotalCMS.resources.servers = undefined;

						//-- 5.50.01.2021.03.30 INDESIGN-3203 When a .jsx has a load
						//--	error, be more precise about which file had the issue.
						err.loadCodeMessage_s = 'Local servers.jsx Error' + ' Error\nThe following file failed to load:\n   ' + decodeURIComponent(this.com.townnews.BLOXTotalCMS.launch.userServers.fsName) + '\n\nThe error was ' + err.name + ': ' + err.message + '\n\nThe launch of the BLOX Total CMS client will continue, but some functions might not function correctly or as expected.'
						alert(err.loadCodeMessage_s, 'BLOX Total CMS servers.jsx Error', true);

					}

				} else if (this.com.townnews.BLOXTotalCMS.launch.serverServers.exists) {

					//-- 5.36.24.2019.04.26 INDESIGN-2540 protect this so that if the
					//--	servers file has language issues, login can proceed.
					try {
						//-- 5.42.21.2020.03.09 INDESIGN-2814 add a new item to allow
						//--	the logging of the loaded servers.jsx file.
						this.com.townnews.BLOXTotalCMS.launch.attemptedServerServers_b = true;

						this.com.townnews.BLOXTotalCMS.launch.loadResult = app.doScript(this.com.townnews.BLOXTotalCMS.launch.serverServers, ScriptLanguage.javascript);
						this.com.townnews.BLOXTotalCMS.resources.loaded[ this.com.townnews.BLOXTotalCMS.launch.serverServers.name ] = this.com.townnews.BLOXTotalCMS.launch.serverServers;
						this.com.townnews.BLOXTotalCMS.resources.servers = servers();
						//-- 5.42.21.2020.03.09 INDESIGN-2814 add a new item to allow
						//--	the logging of the loaded servers.jsx file.
						this.com.townnews.BLOXTotalCMS.launch.serversJSX_f = this.com.townnews.BLOXTotalCMS.launch.serverServers;

					} catch (err) {

						//-- 5.36.25.2019.05.06 INDESIGN-2547 provide a way to watch
						this.com.townnews.BLOXTotalCMS.localError = err;

						//-- 5.42.21.2020.03.09 INDESIGN-2814 If this errored, clear
						//--	the value so that it will trigger a warning in
						//--	'startup_loginAndSetupMenusAndEvents'
						this.com.townnews.BLOXTotalCMS.resources.servers = undefined;

						//-- 5.50.01.2021.03.30 INDESIGN-3203 When a .jsx has a load
						//--	error, be more precise about which file had the issue.
						err.loadCodeMessage_s = 'Global servers.jsx Error\nThe following file failed to load:\n   ' + decodeURIComponent(this.com.townnews.BLOXTotalCMS.launch.serverServers.fsName) + '\n\nThe error was ' + err.name + ': ' + err.message + '\n\nThe launch of the BLOX Total CMS client will continue, but some functions might not function correctly or as expected.'
						alert(err.loadCodeMessage_s, 'BLOX Total CMS servers.jsx Error', true);

					}

				} else {

					//-- 5.43.16.2020.07.22 INDESIGN-2920 NO 'servers.jsx' file found
					this.com.townnews.BLOXTotalCMS.resources.servers = undefined;
					//-- it will be set later
				}

			}


			//----------------------------------------
			//-- C R O S S   D O M A I N   C L O N E
			//-- R E S O U R C E
			//----------------------------------------
			//-- 5.68.00-1.2024.01.03 INDESIGN-4194 copy the UXP Script for
			//--	`Cross Domain Clone...' to the local workstation's
			//--	Resources//--	folder. This is only for
			//--	Adobe InDesign Creative Cloud users. This is yet another
			//--	thing disabled for Creative Suite users.
			//-- 5.68.00-1.2024.01.23 INDESIGN-4194 no longer using this.
			//--	Switched to a ScriptUI based dialog
			// if ((!this.com.townnews.BLOXTotalCMS.launch.triedToDie_b) && this.com.townnews.BLOXTotalCMS.host.isInDesign && this.com.townnews.BLOXTotalCMS.host.isCC) {

			// 	//-- As with other items above, check for the idjs file
			// 	//--	`clonePageDialog.idjs` locally first. If it exists
			// 	//--	then check its modification date. If a newer version
			// 	//--	exists on the server, then copy it over.
			// 	this.com.townnews.BLOXTotalCMS.launch.userClonePageDialog = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local + '/clonePageDialog.idjs');
			// 	this.com.townnews.BLOXTotalCMS.launch.serverClonePageDialog = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/clonePageDialog.idjs');

			// 	if (this.com.townnews.BLOXTotalCMS.launch.userClonePageDialog.exists) {

			// 		if (!this.com.townnews.BLOXTotalCMS.launch.serverClonePageDialog.exists && (this.com.townnews.BLOXTotalCMS.launch.serverClonePageDialog.modified > this.com.townnews.BLOXTotalCMS.launch.userClonePageDialog.modified)) {

			// 			//-- copy the file from the server to the local folder
			// 			if (!this.com.townnews.BLOXTotalCMS.launch.serverClonePageDialog.copy(this.com.townnews.BLOXTotalCMS.launch.userClonePageDialog)) {

			// 				die('Failed to install the Cross Domain Clone Resource file. (1)\n\nExpected at:\n   ' + decodeURIComponent(this.com.townnews.BLOXTotalCMS.launch.serverClonePageDialog.fsName));

			// 			}

			// 		}

			// 	} else if (this.com.townnews.BLOXTotalCMS.launch.serverClonePageDialog.exists) {

			// 		if (!this.com.townnews.BLOXTotalCMS.launch.serverClonePageDialog.copy(this.com.townnews.BLOXTotalCMS.launch.userClonePageDialog)) {

			// 			die('Failed to update the Cross Domain Clone Resource file. (2)\n\nExpected at:\n   ' + decodeURIComponent(this.com.townnews.BLOXTotalCMS.launch.serverClonePageDialog.fsName));

			// 		}

			// 	} else {

			// 		debugger;

			// 		die('Failed to find the Cross Domain Clone Resource file. (3)\n\nExpected at:\n   ' + decodeURIComponent(this.com.townnews.BLOXTotalCMS.launch.serverClonePageDialog.fsName));

			// 	}

			// }


			//---------------------------------------------
			//-- F I N I S H
			//---------------------------------------------
			//-- 5.53.15.2021.09.13 INDESIGN-3439 check flag, do this section if false
			if (!this.com.townnews.BLOXTotalCMS.launch.triedToDie_b) {

				//--------------------------------------------------------------------
				//-- O V E R I D E S   S P E C I F I C   F I L E S
				//--------------------------------------------------------------------
				//-- 4.33, skip this if it is a standalone adMarket Install
				//-- 4.65.25, and the same if it is ad owl stand alone
				//-- 5.42.19.2020.03.02 INDESIGN-1629 remove an if for AdMarket and/or
				//--	AdOwl which can't be true
				startup_locateOverrides();
				//-- Now load those override files
				if (this.com.townnews.BLOXTotalCMS.resources.overrides.files != null) {
					this.com.townnews.BLOXTotalCMS.resources.overrides.numFiles = this.com.townnews.BLOXTotalCMS.resources.overrides.files.length;

					//-- loop through those files
					for (this.com.townnews.BLOXTotalCMS.launch.fi = 0; this.com.townnews.BLOXTotalCMS.launch.fi < this.com.townnews.BLOXTotalCMS.resources.overrides.files.length; this.com.townnews.BLOXTotalCMS.launch.fi++) {

						//-- skip file jsx versions if the file has already been
						//--	loaded
						this.com.townnews.BLOXTotalCMS.launch.jsxName = File(this.com.townnews.BLOXTotalCMS.resources.overrides.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]).nameWithoutExtension();

						if (!this.com.townnews.BLOXTotalCMS.resources.loaded.hasOwnProperty(this.com.townnews.BLOXTotalCMS.launch.jsxName)) {

							//-- 5.50.01.2021.03.29 INDESIGN-3203 Add a new try/catch
							//--	to alert on the details of problems with loading
							//--	the Add-Ons. 
							try {

								//-- Use doScript to read the file and execute it
								this.com.townnews.BLOXTotalCMS.launch.loadResult = app.doScript(this.com.townnews.BLOXTotalCMS.resources.overrides.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]);

								//-- Add the raw filename to the loaded files to
								//--	for later logging.
								this.com.townnews.BLOXTotalCMS.resources.loaded[ this.com.townnews.BLOXTotalCMS.launch.jsxName ] = this.com.townnews.BLOXTotalCMS.resources.overrides.files[ this.com.townnews.BLOXTotalCMS.launch.fi ];

							} catch (err) {

								//-- 5.50.01.2021.03.30 INDESIGN-3203 When a .jsx has a load
								//--	error, be more precise about which file had the issue.
								err.loadCodeMessage_s = this.com.townnews.BLOXTotalCMS.launch.jsxName + ' Error\nThe following file failed to load:\n   ' + decodeURIComponent(this.com.townnews.BLOXTotalCMS.resources.overrides.files[ this.com.townnews.BLOXTotalCMS.launch.fi ].fsName) + '\n\nThe error was ' + err.name + ': ' + err.message + '\n\nThe launch of the BLOX Total CMS client will continue, but some functions might not function correctly or as expected.'
								alert(err.loadCodeMessage_s, 'BLOX Total CMS Load', true);

							}
						}
					}
				}

				//--------------------------------------------------------------------
				//-- C E N T E R   S P E C I F I C   S C R I P T S -- A D D - O N S
				//--------------------------------------------------------------------
				{
					//-- 4.31.2 Load the centerSpecific Scripts.
					//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
					this.com.townnews.BLOXTotalCMS.resources.centerSpecific = {};

					//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
					//~ 		this.com.townnews.BLOXTotalCMS.resources.centerSpecific.folder = new Folder (this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.parent + '/Add-ons') ;
					//-- 5.32.26
					this.com.townnews.BLOXTotalCMS.resources.centerSpecific.folder = new Folder(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d + '/Add-ons');

					if (this.com.townnews.BLOXTotalCMS.resources.centerSpecific.folder.exists) {

						//-- 4.40.8 change to the way 'getFiles' is used
						this.com.townnews.BLOXTotalCMS.resources.centerSpecific.files = this.com.townnews.BLOXTotalCMS.resources.centerSpecific.folder.getFilesWithSuffix('.jsx*');
						if (this.com.townnews.BLOXTotalCMS.resources.centerSpecific.files != null) {

							this.com.townnews.BLOXTotalCMS.resources.centerSpecific.numFiles = this.com.townnews.BLOXTotalCMS.resources.centerSpecific.files.length;

							//loop and load
							for (this.com.townnews.BLOXTotalCMS.launch.fi = 0; this.com.townnews.BLOXTotalCMS.launch.fi < this.com.townnews.BLOXTotalCMS.resources.centerSpecific.files.length; this.com.townnews.BLOXTotalCMS.launch.fi++) {

								try {

									//-- Use doScript to read the Add-Ons file and execute it
									this.com.townnews.BLOXTotalCMS.launch.loadResult = app.doScript(this.com.townnews.BLOXTotalCMS.resources.centerSpecific.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]);
									//-- Add the raw filename to the loaded files
									this.com.townnews.BLOXTotalCMS.resources.loaded[ File(this.com.townnews.BLOXTotalCMS.resources.centerSpecific.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]).nameWithoutExtension() ] = this.com.townnews.BLOXTotalCMS.resources.centerSpecific.files[ this.com.townnews.BLOXTotalCMS.launch.fi ];

								} catch (err) {

									//-- 5.50.01.2021.03.30 INDESIGN-3203 When a .jsx has a load
									//--	error, be more precise about which file had the issue.
									err.loadCodeMessage_s = 'Error Loading an Add-On\nThe following file failed to load:\n   ' + decodeURIComponent(this.com.townnews.BLOXTotalCMS.resources.centerSpecific.files[ this.com.townnews.BLOXTotalCMS.launch.fi ].fsName) + '\n\nThe error was ' + err.name + ': ' + err.message + '\n\nThe launch of the BLOX Total CMS client will continue, but some functions might not function.'
									alert(err.loadCodeMessage_s, 'BLOX Total CMS Load', true);

								}
							}
						}

					} else {

						//-- INDESIGN-2229
						this.com.townnews.BLOXTotalCMS.resources.centerSpecific.folder.verify();

					}
				}

				//---------------------------------------------------------------------
				//-- Version Folders Parent
				//---------------------------------------------------------------------
				//-- used in pathConfiguration to locate the several different folders
				this.com.townnews.BLOXTotalCMS.resources.versionFoldersParent_d = this.com.townnews.BLOXTotalCMS.resources.centerSpecific.folder;


				//----------------------------
				//-- C U R L   L I B R A R Y
				//----------------------------
				{
					//-- 5.15.39.2016.11.04 INDESIGN-1301 Copy CURL library to
					//--	local resources
					//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
					this.com.townnews.BLOXTotalCMS.resources.CURL = {};

					this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = pathsAndPrefs_versionIsNewerThanOrEqualToTarget(this.com.townnews.BLOXTotalCMS.scriptVersion, '5.15.39', 3);
					if (this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b) {

						if (this.com.townnews.BLOXTotalCMS.host.isWindows64Bit) {

							this.com.townnews.BLOXTotalCMS.resources.CURL.library_FileName_s = "HttpLib64.dll";

						} else if (this.com.townnews.BLOXTotalCMS.host.isWindows32Bit || this.com.townnews.BLOXTotalCMS.host.isWindows) {

							this.com.townnews.BLOXTotalCMS.resources.CURL.library_FileName_s = "HttpLib.dll";

						} else if (this.com.townnews.BLOXTotalCMS.host.isMacOS) {

							this.com.townnews.BLOXTotalCMS.resources.CURL.library_FileName_s = "HttpLib.framework.zip";
							this.com.townnews.BLOXTotalCMS.resources.CURL.library_Framework_s = "HttpLib.framework";

						} else {

							this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;

						}
					}
					if (this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b) {

						this.com.townnews.BLOXTotalCMS.resources.CURL.serverFile_f = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/' + this.com.townnews.BLOXTotalCMS.resources.CURL.library_FileName_s);

						this.com.townnews.BLOXTotalCMS.resources.CURL.localFile_f = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local + '/' + this.com.townnews.BLOXTotalCMS.resources.CURL.library_FileName_s);

						//--------------------------
						//-- W I N D O W S   D L L
						//--------------------------
						if (this.com.townnews.BLOXTotalCMS.host.isWindows) {

							if (!this.com.townnews.BLOXTotalCMS.resources.CURL.serverFile_f.exists) {

								this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;

							} else {

								if (!this.com.townnews.BLOXTotalCMS.resources.CURL.localFile_f.exists) {

									if (!this.com.townnews.BLOXTotalCMS.resources.CURL.serverFile_f.copy(this.com.townnews.BLOXTotalCMS.resources.CURL.localFile_f)) {

										debugger;

										this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;

									}

								} else {
									//-- 5.15.39.2016.11.07 INDESIGN-1301 if the length is
									//--	different, or the modification date is
									//--	different, assume it is a different version
									//--	and recopy it locally.
									if ((this.com.townnews.BLOXTotalCMS.resources.CURL.serverFile_f.modified > this.com.townnews.BLOXTotalCMS.resources.CURL.localFile_f.modified) || (this.com.townnews.BLOXTotalCMS.resources.CURL.serverFile_f.length != this.com.townnews.BLOXTotalCMS.resources.CURL.localFile_f.length)) {

										if (!this.com.townnews.BLOXTotalCMS.resources.CURL.serverFile_f.copy(this.com.townnews.BLOXTotalCMS.resources.CURL.localFile_f)) {

											debugger;

											this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;

										}
									}
								}
							}

						} else if (this.com.townnews.BLOXTotalCMS.host.isMacOS) {

							//----------------------------------
							//-- M a c O S   F R A M E W O R K
							//----------------------------------
							//-- Do not replicate nor decompress if in debug mode
							if ($.level > 0) {

								//------------------------------------
								//-- M a c O S   D E B U G   M O D E
								//------------------------------------
								//
								//-- When testing in debug mode, just use the "Server's"
								//--	version of the .framework "folder". Do not
								//--	un-compress and use a local freshly uncompressed
								//--	version as then the .framework itself cannot be
								//--	debugged.
								this.com.townnews.BLOXTotalCMS.resources.CURL.localFile_f = this.com.townnews.BLOXTotalCMS.resources.CURL.serverFile_f = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/' + this.com.townnews.BLOXTotalCMS.resources.CURL.library_FileName_s);

							} else {

								//----------------------------
								//-- N O R M A L   M a c O S
								//----------------------------
								this.com.townnews.BLOXTotalCMS.resources.CURL.serverZipFile_f = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/' + this.com.townnews.BLOXTotalCMS.resources.CURL.library_FileName_s);

								this.com.townnews.BLOXTotalCMS.resources.CURL.localZipFile_f = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local + '/' + this.com.townnews.BLOXTotalCMS.resources.CURL.library_FileName_s);

								this.com.townnews.BLOXTotalCMS.resources.CURL.localFrameworkFolder_d = Folder(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local + '/' + this.com.townnews.BLOXTotalCMS.resources.CURL.library_Framework_s);

								if (!this.com.townnews.BLOXTotalCMS.resources.CURL.serverZipFile_f.exists) {

									this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;

								} else {

									if (!this.com.townnews.BLOXTotalCMS.resources.CURL.localZipFile_f.exists) {

										debugger;

										if (!this.com.townnews.BLOXTotalCMS.resources.CURL.serverZipFile_f.copy(this.com.townnews.BLOXTotalCMS.resources.CURL.localZipFile_f)) {

											this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;

										} else if (!MacOS_UN_zip(this.com.townnews.BLOXTotalCMS.resources.CURL.localZipFile_f, this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local, true)) {

											//------------------------------------------
											//-- M a c O S   N O   D E C O M P R E S S
											//------------------------------------------
											//-- 5.33.09.2018.10.10 INDESIGN-2363 no
											//--	decompress if disabled file exists
											//--	see else if above

											// decompress it
											//-- 5.16.02.2016.11.17 The decompression should
											//--	happen in the resources folder, NOT the
											//--	another layer of framework folders
											this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;

										}

									} else {

										//-- 5.15.39.2016.11.07 INDESIGN-1301 if the length is
										//--	different, or the modification date is
										//--	different, assume it is a different version
										//--	and recopy it locally.
										//-- 5.16.03.2016.11.18 INDESIGN-1503 set this
										//--	procedure to happen always until reaching
										//--	client 5.18. This to aid in the installation
										//--	of this process.
										if ((!pathsAndPrefs_versionIsNewerThanOrEqualToTarget(this.com.townnews.BLOXTotalCMS.scriptVersion, '5.18', 2)) || (this.com.townnews.BLOXTotalCMS.resources.CURL.serverZipFile_f.modified > this.com.townnews.BLOXTotalCMS.resources.CURL.localZipFile_f.modified)) {

											if (!this.com.townnews.BLOXTotalCMS.resources.CURL.serverZipFile_f.copy(this.com.townnews.BLOXTotalCMS.resources.CURL.localZipFile_f)) {

												debugger;

												this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;

											} else if (!this.com.townnews.BLOXTotalCMS.resources.disabled.hasOwnProperty('updateFramework')) {

												//------------------------------------------
												//-- M a c O S   N O   D E C O M P R E S S
												//------------------------------------------
												//-- 5.33.09.2018.10.10 INDESIGN-2363 no
												//--	decompress if disabled file exists
												//--	see else if above

												// decompress it
												//-- 5.16.02.2016.11.17 The decompression should
												//--	happen in the resources folder, NOT the
												//--	another layer of framework folders
												if (!MacOS_UN_zip(this.com.townnews.BLOXTotalCMS.resources.CURL.localZipFile_f, this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local, true)) {

													this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;

												}
											}
										}
									}
								}
							}
						}
					}
				}

				//----------------------------------------------------------
				//-- F I N A L   S T E P S
				//----------------------------------------------------------
				//-- Everything is supposed to be loaded by now except for the
				//--	site specific configuration files which are to be loaded
				//--	as needed by their functions.
				//-- 5.43.02.2020.04.05 INDESIGN-2766 if this is a debug_o login
				//--	this should all be skipped
				if ((this.debug_o == undefined) || (!this.debug_o.loggedIn)) {

					//-- set the default server if it wasn't loaded earlier
					if (this.com.townnews.BLOXTotalCMS.resources.servers == undefined) {

						//NO servers.jsx file;
						this.com.townnews.BLOXTotalCMS.launch.defaultServer = login_getDefaultServer();
						this.com.townnews.BLOXTotalCMS.resources.servers = [ { name: this.com.townnews.BLOXTotalCMS.launch.defaultServer, address: this.com.townnews.BLOXTotalCMS.launch.defaultServer } ];

					}

					//-- 4.31.14, locate the general documents as part of the
					//--	resources and then list the filenames as well
					locateGeneralDocuments();

					//-- 5.61.00-7.2022.06.08 INDESIGN-3849 call the function to
					//--	establish the language translations
					this.com.townnews.BLOXTotalCMS.language = new Language();
					this.com.townnews.BLOXTotalCMS.language.buildDatabase(this.com.townnews.BLOXTotalCMS.host.language_s, $.level > 0);


					//--------------------------------------------
					//-- A U T O M A T E D   P R O D U C T I O N
					//-- D A T A B A S E   G L O B A L
					//--------------------------------------------
					//-- 5.72.00-01.2024.05.29 INDESIGN-3765 create the global
					//--	for the Automated Production Geometry Database
					g_geometries_rawResults_byDomainNameWithDot_o = {};
					g_geometries_processed_byDomainNameWithDot_o = {};
					//-- 5.73.00-03.2024.09.12 INDESIGN-4321 add a global to
					//--	keep track of how many times the user manually
					//--	places a snippet so that we can prompt to use the
					//--	BLOX Total CMS Plug-in for Adobe InDesign
					//-- 5.73.00-03.2024.09.13 INDESIGN-4321, not seeing the
					//--	value in the function, perhaps these all need to be
					//--	`this.g_`
					this.g_geometries_numberPlaced_i = 0;
					//-- 5.73.00-04.2024.09.12 INDESIGN-4321 add a global to
					//--	indicate how many placements should happen between
					//--	warnings to upgrade to the BLOX Total CMS Plug-in
					//--	for Adobe InDesign. Start with a random number
					//--	between 5 and 11.
					this.g_geometries_warnEveryPlacements_i = Math.floor(Math.random() * 7) + 5;


					//---------------------------------------------------------------------
					//-- Enable Logs and other items.
					//-- 4.68.04, 2012.08.28, check for a valid login setup
					//-- 5.43.02.2020.03.19 INDESIGN-2766 'startup_onLaunch4' sets some globals
					if (startup_onLaunch4()) {

						//-- 5.43.02.2020.03.19 INDESIGN-2766 'launchLogLaunchDetails'
						//--	does logging
						//-- 5.43.03.2020.04.09 INDESIGN-2766 that function now also log
						//--	additional summery details on the .disabled and .enabled
						//--	files that the core function also logs.
						startup_launchLogLaunchDetails();

						//-- login should happen here
						//-- 4.21 Radically new setup for loading the event handlers
						//-- 4.31.2 again change the function call for handling the login.
						//-- 4.33 if an AdMarket install then the setup is different
						//-- 4.65.25, 2012.05.30, also different for Ad Owl stand alone
						//-- 5.37.10.2019.07.02 no ticket, remove adOwl and AdMarket
						//--	and then pass temporary items
						//-- 5.41.03.2019.10.24 INDESIGN-2647 pass true for lazyLaunch_b
						//--------------
						//-- L O G I N
						//--------------
						this.com.townnews.BLOXTotalCMS.launch.setupResult = startup_loginAndSetupMenusAndEvents(false, this.debug_o, true);

						//-- 5.12.20.2015.07.27 INDESIGN-622 more control for when login fails.
						if (this.com.townnews.BLOXTotalCMS.launch.setupResult == true) {

							//-- 5.57.00.2022.02.01 INDESIGN-3573 call a function to
							//--	attempt to open a document if this is MacOS Monterey
							//--	which has a bug with InDesign menus.
							//-- 5.65.00-4.2022.12.14 INDESIGN-3995 use new function to
							//--	determine if the workaround should be used
							// if ((this.com.townnews.BLOXTotalCMS.host.isMacOSMonterey_b === true) && (this.com.townnews.BLOXTotalCMS.host.isInDesign === true) && this.com.townnews.BLOXTotalCMS.host.isCC_2017_orNewer_b) {
							if (plugIn_useWorkaround()) {

								//-- 5.72.00-08.2024.08.05 INDESIGN-4294
								//--	attempt to read a user preference. If
								//--	set to true, use the legacy method of
								//--	opening and closing a document.
								//--	Otherwise try the newer version of
								//--	creating and closing a document.
								//-- Because of the odd way that the Settings
								//--	and Support option was created, it can
								//--	be checked but not enabled. That would
								//--	trigger the below. So check here that
								//--	it is enabled before using it's value.
								//-- 5.72.00-10.2024.09.11 INDESIGN-1850 switch
								//--	to hard coded key because the keyring
								//--	might not exist
								if ((true === this.com.townnews.BLOXTotalCMS.preferences.getBooleanValue('useMacOSWorkaround')) && (true === this.com.townnews.BLOXTotalCMS.preferences.getBooleanValue(this.com.townnews.BLOXTotalCMS.keyRing.useMacOSLegacyOpenAndClose_b))) {

									if (this.com.townnews.BLOXTotalCMS.hasOwnProperty('log')) {

										var reg = this.com.townnews.BLOXTotalCMS.log.reg('townnews-plug-in', [ 'townnews-plug-in' ], true);
										var msg = 'The user has specifically enabled the Legacy document form of macOS workaround via an option in `Settings and Support...` (mosw4294)-B';
										this.com.townnews.BLOXTotalCMS.log.iLog(reg, msg, true);

									}

									plugIn_attemptToOpenAndCloseWorkaroundDocument(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local, this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server, this.com.townnews.BLOXTotalCMS.launch.setupResult);

								} else {

									plugIn_attemptToCreateAndCloseDocument();

								}

							}

							//-- 4.31.11 move to separate function
							startup_launchDisplayFinalMessages();

						}
					}

				} else {

					//-- 5.53.02.2021.07.26 INDESIGN-3357 call function to build the
					//--	client release folder
					update_buildShareClientsVersionFolder();

					//-- 5.43.02.2020.04.06 INDESIGN-2766 testing theory
					app.activate();

					this.com.townnews.BLOXTotalCMS.launch.msg = 'Development Relaunch Complete...';
					this.com.townnews.BLOXTotalCMS.launch.ll.iLog(this.com.townnews.BLOXTotalCMS.launch.reg, this.com.townnews.BLOXTotalCMS.launch.msg, true);
					alert$(this.com.townnews.BLOXTotalCMS.launch.msg, this.com.townnews.BLOXTotalCMS.launch.msg, false);

				}

				//-- 4.03 try to delete global name space variable
				delete this.com.townnews.BLOXTotalCMS.launch;
				//-- 5.37.10.2019.07.02 no ticket, delete this temporary item.
				delete this.debug_o;

				//-- 5.61.00-1.2022.05.11 INDESIGN-3521 call the function to
				//--	validate the loaded files
				idle_checkInstallation_setup();

			}

		}

	}

} catch (err) {

	//-- 5.36.25.2019.05.06 INDESIGN-2547 provide a way to watch
	this.com.townnews.BLOXTotalCMS.localError = err;
	var localError = err;

	//-- 5.50.01.2021.03.29
	if (err.hasOwnProperty('loadCodeMessage_s')) {

		handleLoadError(err);

	} else {

		handleError(err, undefined, undefined, true, false, 'BLOX Total CMS Plug-in Launch Error');

	}

}
//
//
function plugIn_attemptToCreateAndCloseDocument () {

	//-------------------------------------------------------------------------
	//-- P L U G - I N
	//-- A T T E M P T   T O   C R E A T E   A N D   C L O S E   D O C U M E N T
	//-------------------------------------------------------------------------
	//-- Purpose: Rather than opening a document to work around the MacOS issue
	//--	of mucking up the menu access, it has been predicted that just
	//--	creating a document will work. This function attempts to do that.
	//-------------------------------------------------------------------------
	//-- Parameters:
	//--	None!
	//-------------------------------------------------------------------------
	//-- Returns:
	//--	null
	//-------------------------------------------------------------------------
	//-- Created from scratch starting 2024.04.08 for INDESIGN-4246 in 5.70.00-03
	//-------------------------------------------------------------------------

	var err = null;
	var ll = this.com.townnews.BLOXTotalCMS.log;
	var localError = null;
	var msg = 'starting...';
	var reg = ll.reg(arguments.callee.name, [ 'townnews-plug-in' ], true);

	try {

		//-- create it
		var temporaryDocRef_o = app.documents.add(true);

		//-- verify that the document was created
		if (temporaryDocRef_o.isValid) {

			//-- creating a document _can_ cause event handlers to trigger.
			//--	I checked and they appear to have already been set up,
			//--	so will ask to ignore this document.
			if (!this.com.townnews.BLOXTotalCMS.hasOwnProperty('docsToIgnore')) {

				this.com.townnews.BLOXTotalCMS.docsToIgnore = {};

			}
			this.com.townnews.BLOXTotalCMS.docsToIgnore[ temporaryDocRef_o.id ] = true;

			//-- close without saving
			temporaryDocRef_o.close(SaveOptions.NO);

		}

	} catch (err) {

		localError = err;

		msg = 'The following error prevented using a new document to work past macOS\'s problems with Adobe InDesign menus: ' + localError;
		ll.wLog(reg, msg, true);

		debugger;

		silentErrorLog(err, reg);

	}

	return null;

}
//
function plugIn_attemptToOpenAndCloseWorkaroundDocument (p_destination_d, p_source_d, loggedIn_b) {

	//-------------------------------------------------------------------------
	//-- P L U G - I N
	//-- A T T E M P T   T O   O P E N   A N D   D O C U M E N T
	//-------------------------------------------------------------------------
	//-- Purpose: MacOS Monterey (12.x) had/has a bug where the menus will not
	//--	activate property. A work around appears to be opening a document.
	//--	This function attempts to do that.
	//-------------------------------------------------------------------------
	//-- Parameters:
	//-------------------------------------------------------------------------
	//-- Returns:
	//--	nothing important
	//-------------------------------------------------------------------------
	//-- Created from scratch on 2022.02.01 for INDESIGN-3573
	//-------------------------------------------------------------------------

	const doNotPromptForCheckIn_b = true;
	const doNotPromptForPageNotes_b = true;
	const doNotUpdatePageTracker_b = true;
	const noSave_b = true;
	const openVisibly_b = false;
	var docID_i = undefined;
	var docRef_o = { isValid: false };
	var documentFile_f = null;
	var documentName_s = '';
	var err = null;
	var ll = this.com.townnews.BLOXTotalCMS.log;
	var localError = null;
	var msg = 'starting...';
	var reg = ll.reg(arguments.callee.name, [ 'plug-in' ], true);
	var sourceFile_f = null;


	try {

		if (!p_destination_d) {

			msg = 'p_destination_d is undefined';
			ll.wLog(reg, msg, true);

			debugger;

			return null;

		}
		if (!p_destination_d.exists) {

			msg = 'p_destination_d does not exist';
			ll.wLog(reg, msg, true);

			debugger;

			return null;

		}

		//-- 5.64.00-01.2022.12.07 INDESIGN-3959 call the function to get the
		//--	full document name based upon the os version
		//-- 5.65.00-6.2023.01.04 INDESIGN-3956 call a new function to get the
		//--	file extension for InCopy or Adobe InDesign
		// documentName_s = plugIn_returnWorkaroundDocumentName() + documentNameSuffix_s;
		//-- 5.65.00-7.2023.01.18 INDESIGN-3995 bug fix to
		//--	add the '.' which had been missing
		documentName_s = plugIn_returnWorkaroundDocumentName() + '.' + plugIn_returnWorkaroundExtension();

		//-- Get file reference
		documentFile_f = new File(p_destination_d + '/' + documentName_s);

		if (!documentFile_f.exists) {

			//-- The file doesn't exist, attempt to copy it there from the server
			if (!p_source_d) {

				msg = 'p_source_d is undefined';
				ll.wLog(reg, msg, true);

				debugger;

				return null;

			}
			if (!p_source_d.exists) {

				msg = 'p_source_d does not exist';
				ll.wLog(reg, msg, true);

				debugger;

				return null;

			}
			sourceFile_f = new File(p_source_d + '/' + documentName_s);
			if (!sourceFile_f.exists) {

				msg = 'sourceFile_f does not exist. Looked here:\n   ' + decodeURIComponent(sourceFile_f.fsName);
				ll.wLog(reg, msg, true);

				debugger;

				return null;

			}
			//-- 5.68.00-1.2024.01.11 INDESIGN-4185 adding more logging to know the source and date of the file
			msg = 'About to locally install the osWorkaround file...\n   ' +
				'  Source Path: ' + decodeURIComponent(sourceFile_f.fsName) + '\n   ' +
				' Date Created: ' + sourceFile_f.created + '\n   ' +
				'Last Modified: ' + sourceFile_f.modified;
			ll.iLog(reg, msg, true);

			//-- Attempt to Copy the file
			if (!sourceFile_f.copy(documentFile_f)) {

				msg = 'Failed to copy the source to the destination.\n   ' +
					'     Source: ' + decodeURIComponent(sourceFile_f.fsName) + '\n   ' +
					'Destination: ' + decodeURIComponent(documentFile_f.fsName);
				ll.wLog(reg, msg, true);

				debugger;

				return null;

			}

			if (!documentFile_f.exists) {

				msg = 'The workaround file is not where it is expected to be. Looked here:\n   ' + decodeURIComponent(documentFile_f.fsName);
				ll.wLog(reg, msg, true);

				debugger;

				return null;

			}

		}

		//-- 5.60.00-1.2022.03.03 INDESIGN-3695 while testing that ticket,
		//--	there is a series of modal dialogs that prevent this from
		//--	being used.
		if (app.modalState) {

			msg = 'While this is a macOS based host, unfortunately there is a modal dialog open. Can NOT do the opening of the workaround document. Returning null...';
			ll.iLog(reg, msg, true);

			return null;

		}

		//-- 5.68.00-1.2024.01.11 INDESIGN-4185 add the path of the document as well as it modification date:
		msg = 'This is a macOS based host. Opening and closing a document to force the menus to behave.\n   ' +
			'Document Path: ' + decodeURIComponent(documentFile_f.fsName) + '\n   ' +
			' Date Created: ' + documentFile_f.created + '\n   ' +
			'Last Modified: ' + documentFile_f.modified;
		ll.iLog(reg, msg, true);


		//--------------------------
		//-- O P E N   V I A   O S
		//--------------------------
		//-- At this point, the document file exists, attempt to open it
		//-- IMPORTANT: the OS needs to open the file to prevent the issue
		//--	with the menus
		if (!documentFile_f.execute()) {

			msg = 'Failed to open the following document via the OS:\n   ' + decodeURIComponent(documentFile_f.fsName);
			ll.wLog(reg, msg, true);

			debugger;

			return null;

		}
		msg = 'The OS opened the \'' + documentName_s + '\' document.';
		ll.iLog(reg, msg, true);

		//--------------------------------------------------
		//-- O P E N   V I A   A D O B E   I N D E S I G N
		//--------------------------------------------------
		//-- That OS based open doesn't provide a way to get a reference to
		//--	the document. However, by asking Adobe InDesign to open the
		//--	same document that we can get the reference and yet the
		//--	'magic' of having the OS open it will still be in force...
		//--	However, the request to NOT open visibly is basically ignored
		//--	since the document is already open from the above block which
		//--	used the OS to open the document and it always opens visibly.
		docRef_o = app.open(documentFile_f, openVisibly_b);
		if (!docRef_o.isValid) {

			msg = 'Did not get a valid document reference from attempting to re-open the workaround document from Adobe InDesign after asking the OS to open it.';
			ll.wLog(reg, msg, true);

			debugger;

			return null;

		}
		docID_i = docRef_o.id;


		//-- so, the process to close on idle can run into a case where it
		//--	wants to prevent closing when there are background tasks.
		//--	So add a flag to allow that check to be skipped.
		if (!this.com.townnews.BLOXTotalCMS.hasOwnProperty('docsToClose')) {

			this.com.townnews.BLOXTotalCMS.docsToClose = {};

		}
		this.com.townnews.BLOXTotalCMS.docsToClose[ docID_i ] = true;

		if (loggedIn_b) {

			//-- 5.68.00-1.2024.01.11 INDESIGN-4185 more logging.
			msg = 'Asking for the \'' + documentName_s + '\' document with the ID: \'' + docID_i + '\' to be close via an idle event...';
			ll.iLog(reg, msg, true);

			//-- Now, ask for the document to close. It's not really open yet as
			//--	app.documents.length is still 0 at this moment
			return closeAndSaveIdle_setup(docID_i, documentName_s, noSave_b, doNotUpdatePageTracker_b, doNotPromptForPageNotes_b, doNotPromptForCheckIn_b);

		}

		//-- just try a document close
		//-- 5.68.00-1.2024.01.11 INDESIGN-4185 more logging.
		msg = 'Asking the \'' + documentName_s + '\' document to close NOW...';
		ll.iLog(reg, msg, true);

		return docRef_o.close(SaveOptions.NO);

	} catch (err) {

		localError = err;

		debugger;

	}

	return false;

}
//
//
function plugIn_returnWorkaroundDocumentName () {

	//-------------------------------------------------------------------------
	//-- P L U G   I N
	//-- R E T U R N   W O R K A R O U N D   D O C U M E N T   N A M E
	//-------------------------------------------------------------------------
	//-- Purpose: Returns a string that represents the name of the macOS based
	//--	document that will be opened to force the menus to behave to 
	//--	workaround a bug with macOS starting with version 12 and
	//--	Adobe InDesign versions 2021 and later.
	//-------------------------------------------------------------------------
	//-- Returns: either a base string or a string that is a combination of an alternate base and the Adobe InDesign version number.
	//-------------------------------------------------------------------------
	//-- Created starting 2022.12.07 for INDESIGN-3959
	//-------------------------------------------------------------------------

	//-- set the default, and legacy value from prior to INDESIGN-3959
	//--	when this function was added
	const baseName_s = 'MontereyWorkaround';
	const rawAppVersionMain_s = app.version.split('.')[ 0 ];
	// debugger;
	if (isNaN(rawAppVersionMain_s)) {

		return baseName_s;

	}

	return 'osWorkaround' + rawAppVersionMain_s;

}
//
//
function plugIn_returnWorkaroundExtension () {

	//-------------------------------------------------------------------------
	//-- P L U G   I N
	//-- R E T U R N   W O R K A R O U N D   E X T E N S I O N
	//-------------------------------------------------------------------------
	//-- Purpose: Returns a string that represents the extension of the macOS
	//--	based document that will be opened to force the menus to behave
	//--	to workaround a bug with macOS starting with version 12 and
	//--	Adobe InDesign / Adobe InCopy versions 2021 and later.
	//-------------------------------------------------------------------------
	//-- Returns: a string that is the extension of the macOS based document
	//-------------------------------------------------------------------------
	//-- Created starting 2023.01.04 for INDESIGN-3956
	//-------------------------------------------------------------------------

	if (this.com.townnews.BLOXTotalCMS.host.isInCopy) {

		return '.icml';

	}

	//-- default is Adobe InDesign .indd document
	return 'indd';

}
//
//
function plugIn_useWorkaround () {

	//-------------------------------------------------------------------------
	//-- P L U G   I N
	//-- U S E   W O R K A R O U N D
	//-------------------------------------------------------------------------
	//-- Purpose: Returns a boolean that indicates if the macOS based
	//--	workaround for the menus is needed.
	//-------------------------------------------------------------------------


	if (!this.com.townnews.BLOXTotalCMS.host.isMacOS) {

		return false;

	}

	//-- 5.72.00-08.2024.08.05 INDESIGN-4294 check to see if the user has
	//--	specifically enabled the option. If that is set to true, then
	//--	return true. Else use the rest of the tests.
	//-- 5.73.00-01.2024.08.07 INDESIGN-691 noticed an issue using
	//--	log out -> log in where the keyring wasn't defined. Will
	//--	hardcode it here to match what was done elsewhere.
	// if (true === this.com.townnews.BLOXTotalCMS.preferences.getBooleanValue(this.com.townnews.BLOXTotalCMS.keyRing.useMacOSWorkaround_b)) {
	if (true === this.com.townnews.BLOXTotalCMS.preferences.getBooleanValue('useMacOSWorkaround')) {

		var ll = this.com.townnews.BLOXTotalCMS.log;
		var msg = 'The user has specifically enabled the use of the macOS workaround via an option in `Settings and Support...` (mosw4294)-A';
		var reg = ll.reg(arguments.callee.name, [ 'townnews-plug-in' ], true);
		ll.iLog(reg, msg, true);

		return true;

	}


	//-- 5.70.00-03.2024.04.08 INDESIGN-4246 Cody asked to skip the
	//--	functionality at macOS 13.5
	var numericalPrefixOfOSVersion_s = this.com.townnews.BLOXTotalCMS.host.st3.substring(13, this.com.townnews.BLOXTotalCMS.host.st3.lastIndexOf('/'));
	if (!pathsAndPrefs_versionIsNewerThanOrEqualToTarget(numericalPrefixOfOSVersion_s /*01 currentVersion_s */, '13.5' /*02 targetVersion_s */, 2 /*03 sections_i */, false /*04 onlyGreaterThan_b */)) {

		return false;

	}

	//-- this.com.townnews.BLOXTotalCMS.host.st3 has something like
	//--	macOS 12.0.1 or 13.1.0
	//-- Create a regular expression that will check is the first number is
	//--	12 through 14 and return false if not
	const test_re = new RegExp('1[2-4]');
	if (!test_re.test(this.com.townnews.BLOXTotalCMS.host.st3)) {

		return false;

	}

	//-- now check the version of Adobe InDesign. The original testing went
	//--	back to CC 2017 but the osWorkaround files are only for versions
	//--	16, 17, and 18.
	//-- so, if the version is less than 16, return false
	if (this.com.townnews.BLOXTotalCMS.host.versionPointer_n < 160) {

		return false;

	}

	//-- 5.66.00-23.2023.08.31 INDESIGN-4136 convert this to higher than 2024
	//--	or version 20 as CC 2024 has been released and I've made an
	//--	`osWorkaround20.indd` file
	//-- if >= than version 200, also return false
	if (this.com.townnews.BLOXTotalCMS.host.versionPointer_n >= 200) {

		return false;

	}

	return true;

}
//
//
function locateRootScriptPath () {

	var err;
	var localError;
	var root_d = null;
	var script_f = null;

	//-- Standard method of locating a script file. If run from the host
	//--	application, it gets correct path. If run from ESTK, it errors
	//--	but knows the path to the script file causing the error. That
	//--	error gets parsed and, due to the constructs of BLOX Total CMS
	//--	we return the path two folders up.
	try {

		script_f = app.activeScript;

	} catch (err) {

		localError = err;
		script_f = new File(err.fileName);

		if (!script_f.exists) {

			return Folder.selectDialog("Select the 'ActiveVersion' folder containing the 'Startup Scripts' and 'resources' folders.");

		}
	}
	root_d = script_f.parent.parent; //-- TWO (2) up. Two thumbs up?
	if (root_d.exists) {

		return Folder(root_d.fsName);

	}

	return Folder.selectDialog("Select the 'ActiveVersion' folder containing the 'Startup Scripts' and 'resources' folders.");

}
//
//
function die (message) {

	//-- 5.53.15.2021.09.13 INDESIGN-3439 set flag
	if (!this.com.townnews.BLOXTotalCMS.hasOwnProperty('launch')) {

		this.com.townnews.BLOXTotalCMS.launch = {};

	}
	this.com.townnews.BLOXTotalCMS.launch.triedToDie_b = true;

	alert('ERROR: The BLOX Total CMS Plug-In is not correctly installed.\n\nFunctionality disabled.' + ((message != undefined) ? '\nDetails: ' + message : ''), 'BLOX Total CMS', true);
	//-- no way to truly exit in CS5 and we don't want to force a quit
	//--	thus, the else

	//-- 5.36.25.2019.05.06 INDESIGN-2547 with new development function,
	//--	just try to quit.
	if ($.level > 0) {

		app.quit();

	}

	//-- KILL ANY PREVIOUS MENU ITEMS
	//-- 5.53.15.2021.09.13 INDESIGN-3439 that header was there, but
	//--	it wasn't set to do anything. Adding function to remove it
	removeMenu(this.com.townnews.BLOXTotalCMS.menuName);


	return null;

}
//
//
function handleError (err, pre, post, showSource, allowContinue, title, silent, reg) {

	//-------------------------------------------------------------------------
	//-- H A N D L E   E R R O R
	//-------------------------------------------------------------------------
	//-- Generic: No. It references hard coded log object.
	//-------------------------------------------------------------------------
	//-- Purpose: This is a generic error handler that can show an error with
	//--		extra information about the line of code that generated the
	//--		error.
	//-------------------------------------------------------------------------
	//-- Parameters: 5
	//--		err: The error object that was caught
	//--		pre: a string that you want to include at the beginning.
	//--		post: a string that you want to include at the end.
	//--		showSource: a boolean. Set to True to display the lines near
	//--			the error.
	//--		allowContinue: a Boolean. When set to true confirm will be
	//--			displayed. And the result of the confirm is returned. When
	//--			set to false, then false will be returned.
	//-------------------------------------------------------------------------
	//-- Returns: the result of the confirm dialog.
	//-------------------------------------------------------------------------


	//-- 5.36.06.2019.02.12 INDESIGN-2143 modernize declarations and add OS
	//--	version if known
	var allLines_a = null;
	var err;
	var errLine_i = 0;
	var li_i = 0;
	var ll = null;
	var localError;
	var logBreak = "\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\n";
	var logPrefix = "\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n";
	var lineAfter_i = 0;
	var lineBefore_i = 0;
	var msg = '';
	var msg_a = new Array();
	var numLinesAfter_i = 2;
	var numLinesBefore_i = 8;
	var r = null;
	var scriptEditDate_s = '';
	var stack_s = null;
	var versionLine_s = '';


	//-- Edited 2009.11.20 to add breaks in the prior lines of code.
	//-- Edited 2010.01.21 to add more breaks to make it more readable.
	//-- Edited 2010.09.20 to allow the continue to be optional.
	if (allowContinue == undefined) {

		allowContinue = true; // default to old behavior

	}
	//-- Use the prefix if it exists
	if (pre) {

		msg = pre + '\n';

	} else {

		msg = '';

	}
	//-- Build the first part of the error.
	//-- 2010.01.29 change to += for version 3.27
	msg += '\nError: ' + err.message + '\n\nType: ' + err.name;
	msg += '\nNumber: ' + err.number;

	//-- Add the source code if it is applicable.
	if (showSource) {

		//-- Edited 2009.02.09 to remove the encoding around the file name
		msg += '\n\nScript:\n   ' + decodeURIComponent(err.fileName) + '\n\nLine: ' + err.line;

		msg += '\n\nSource Dump:';

		if (err.source) {

			//-- Add a heading above prior lines
			//-- Version 3.18 add more space before.
			msg += "\n\nLines Before:\n";

			//-- NOTE: 2010.09.28 the REG EXP on the whole source can be REAL SLOW

			//-- below modified for 2.55
			//-- Below modified for 3.00 to make it a little cleaner
			//--	Tab to space, two spaced to 1 space, starting space to no space.
			allLines_a = err.source.replace(new RegExp('\\t', 'gm'), ' ').replace(new RegExp('  ', 'gm'), ' ').replace(new RegExp('^ *', 'gm'), '').split("\n");

			//-- Determine the index of the first line of the code to display.
			lineBefore_i = err.line - numLinesBefore_i;
			lineBefore_i = (lineBefore_i < 0) ? 0 : lineBefore_i;

			//-- Determine the index of the last line of the code to display
			lineAfter_i = err.line + numLinesAfter_i;
			lineAfter_i = (lineAfter_i > allLines_a.length) ? allLines_a.length : lineAfter_i;

			errLine_i = err.line - 1;
			for (li_i = lineBefore_i; (li_i < lineAfter_i) && (li_i < allLines_a.length); li_i++) {

				if (li_i == errLine_i) {

					//-- Add a header before the header and one for the next lines too
					//-- Version 3.18 Add more space
					msg += "\nError Line:\n" + "   " + allLines_a[ li_i ] + "\n\nNext Lines:\n";

				} else {

					//-- 2009.11.20 add an extra break to make reading the
					//--	prior code easier.
					msg += "   " + allLines_a[ li_i ] + '\n';

				} //-- End of else

			} //-- End of For loop

		} //-- End of if (source exists)

		//-- Version 3.04 add stack to the error message
		try {

			stack_s = returnViewableStack(200, 0, 1);
			if (stack_s != '') {

				msg += '\n' + stack_s;

			}

		} catch (err) {

			localError = err;

		}

	} //-- End of if (showSource)
	//
	//-- Add the post text if it exists and return to caller
	msg = (post ? msg + '\n' + post : msg).replace('\t', ' ');
	//-- Version 2.24, make sure there is a message
	if (msg == undefined) {

		msg = '';

	}
	//-- Version 2.24 make sure the setup has gotten far enough to create a log file
	if (this.hasOwnProperty('com') & this.com.hasOwnProperty('townnews') && this.com.townnews.hasOwnProperty('BLOXTotalCMS') && this.com.townnews.BLOXTotalCMS.hasOwnProperty('log')) {
		//-- 4.48.01, change to a proper log reference. Prior version was just
		//--	a writeln in the log. This should dump to the error logs.
		ll = this.com.townnews.BLOXTotalCMS.log;

		//-- 4.69.29, 2012.10.20, in St. Louis
		//-- 5.36.06.2019.02.12 the test had been != undefined.
		//--	I think it should be undefined
		//-- 5.43.09.2020.06.15 INDESIGN-2896 making sure that
		//--	reg is defined AGAIN!
		if ((reg == undefined) || (!isObject(reg)) || (!isNonEmptyString(reg.prefix))) {
			reg = ll.reg(arguments.callee.name, [ 'handleError' ], true);
		}
		//-- 4.71.56.2013.06.11 Send along the error which will be used
		//--	to add to the log file on the server.
		//-- 5.21.01.2017.09.22 add the client version to the log
		//-- 5.36.06.2019.02.12 INDESIGN-2143 log the OS Version if known
		//-- 5.57.00.2022.02.07 INDESIGN-3648 add the scriptEditDate if known
		//--	Also add an extra separation line before the 'Client Version:'
		scriptEditDate_s = (isNonEmptyString(this.com.townnews.BLOXTotalCMS.scriptEditDate)) ? '/' + this.com.townnews.BLOXTotalCMS.scriptEditDate : '';
		if (this.com.townnews.BLOXTotalCMS.hasOwnProperty('host') && this.com.townnews.BLOXTotalCMS.host.hasOwnProperty('st6') && isNonEmptyString(this.com.townnews.BLOXTotalCMS.host.st6)) {

			//-- 5.36.22.2019.04.02 INDESIGN-2523 swap the order so that
			//--	script version is always last
			ll.eLog(reg, logPrefix + msg + '\nOS Version: ' + this.com.townnews.BLOXTotalCMS.host.st6 + '\n\nClient Version: ' + this.com.townnews.BLOXTotalCMS.scriptVersionNumberWithBuild + scriptEditDate_s + logBreak, err);

		} else {

			//-- legacy without OS Version
			ll.eLog(reg, logPrefix + msg + '\n\nClient Version: ' + this.com.townnews.BLOXTotalCMS.scriptVersionNumberWithBuild + scriptEditDate_s + logBreak, err);

		}
	}
	//-- 4.03 allow a non-confirm dialog to be displayed
	//-- 4.40.4 allow the error to not be displayed to the user:
	if (silent) {

		//-- This next thing is a an attempt to limit crashes by
		//--	keeping the redraw turned off.
		if ((!app.modalState) && app.scriptPreferences.enableRedraw) {

			//-- 5.43.09.2020.06.15 INDESIGN-2896 making sure that reg
			//--	is defined using any way we can
			if ((reg == undefined) || (!isObject(reg)) || (!isNonEmptyString(reg.prefix))) {
				reg = ll.reg(arguments.callee.name, [ 'handleError' ], true);
			}
			msg = 'turning off redraw. (halr2896)';

			ll.iLog(reg, msg, true);
			app.scriptPreferences.enableRedraw = false;
		}

		return false;

	}
	//-- 4.70.15, adding a version tag to this area
	//-- 5.19.05.2017.03.21 Happy Spring INDESIGN-1678, include the
	//--	build number here
	//-- 5.36.06.2019.02.12 INDESIGN-2143 log the OS Version if known
	if (this.com.townnews.BLOXTotalCMS.hasOwnProperty('host') && this.com.townnews.BLOXTotalCMS.host.hasOwnProperty('st6') && isNonEmptyString(this.com.townnews.BLOXTotalCMS.host.st6)) {

		versionLine_s = this.com.townnews.BLOXTotalCMS.scriptVersionNumberWithBuild + '/' + this.com.townnews.BLOXTotalCMS.host.st6;

	} else {

		//legacy without OS version
		versionLine_s = this.com.townnews.BLOXTotalCMS.scriptVersionNumberWithBuild;

	}
	if (allowContinue) {
		//-- Version 2p, Add a custom dialog
		//-- 5.38.03.2019.07.21 switch to a wider dialog using confirm$
		//-- 5.38.06.2019.07.31 can't use confirm$ unless this is a reboot
		if (title == undefined) {
			//-- 5.38.03.2019.07.21 change from 'Translate Error' to 'BLOX Total CMS Error'
			r = confirm("Continue? (" + versionLine_s + ")\n" + msg, true, "BLOX Total CMS Error: ", 469);

		} else {
			r = confirm("Continue? (" + versionLine_s + ")\n" + msg, true, title, 469);
		}
		//-- This next thing is a an attempt to limit crashes by
		//--	keeping the redraw turned off.
		if ((!app.modalState) && app.scriptPreferences.enableRedraw) {

			msg = 'turning off redraw.';
			ll.iLog(reg, msg, true);
			app.scriptPreferences.enableRedraw = false;

		}
		if (r) {

			return (r);

		}

		//-- 5.50.01.2021.03.29 INDESIGN-3203 remove else block because
		//--	if the if is true, then it returns and will never get here.
		//-- 4.21 had tried to exit the app, but that isn't an option
		return false;

	}
	//-- 5.50.01.2021.03.29 INDESIGN-3203 remove else block because the above always returns. 
	//-- 4.72.01.2013.09.12 add the version to these non-continue versions.
	//-- 5.38.03.2019.07.21 switch to a wider dialog using alert$
	//-- 5.38.06.2019.07.31 can't use alert$ unless this is a reboot
	if (title == undefined) {

		//-- 5.38.03.2019.07.21 change from 'Translate Error' to 'BLOX Total CMS Error'
		alert("Version (" + versionLine_s + ")\n" + msg, "BLOX Total CMS Error: ", true, 469);

	} else {

		alert("Version (" + versionLine_s + ")\n" + msg, title, true, 469);

	}

	//-- 4.21 had tried to exit the app, but that isn't an option
	//-- This next thing is a an attempt to limit crashes by
	//--	keeping the redraw turned off.
	if ((!app.modalState) && app.scriptPreferences.enableRedraw) {

		msg = 'turning off redraw.';
		ll.iLog(reg, msg, true);
		app.scriptPreferences.enableRedraw = false;

	}

	return false;

}
//
//
function handleLoadError (err) {

	//-- 5.50.01.2021.03.29 INDESIGN-3202 simplier alert of message
	alert(err.loadCodeMessage_s, 'BLOX Total CMS Load', true);

	return false;

}
//
//
function locateGeneralDocuments () {
	//-- This function created for version 4.31.14
	//-- create the object
	//-- 5.41.07.2019.11.21 no ticket. Convert to basic objects
	this.com.townnews.BLOXTotalCMS.resources.generalDocuments = {};
	//-- set a flag
	this.com.townnews.BLOXTotalCMS.resources.generalDocuments.files = null;

	//-- define the folder
	//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
	//~ 	this.com.townnews.BLOXTotalCMS.resources.generalDocuments.folder = new Folder (this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.parent + '/General Documents') ;
	this.com.townnews.BLOXTotalCMS.resources.generalDocuments.folder = new Folder(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d + '/General Documents');
	//-- verify that it exists
	//-- 4.72.50.2014.02.03 if the legacy folder exists, us that. Else try
	//--	new location and create instead of just verify.

	if (!this.com.townnews.BLOXTotalCMS.resources.generalDocuments.folder.exists) {
		//-- change the path and create the folder.
		//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
		//~ 		this.com.townnews.BLOXTotalCMS.resources.generalDocuments.folder = new Folder (this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.parent + '/General_Documents') ;
		this.com.townnews.BLOXTotalCMS.resources.generalDocuments.folder = new Folder(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d + '/General_Documents');
		if (!this.com.townnews.BLOXTotalCMS.resources.generalDocuments.folder.verify()) {

			return null;
		}
	}
	//-- implied else
	//-- 4.40.8 change to the way 'getFiles' is used
	//-- 5.32.19.2018.07.10 INDESIGN-2273 sort the docs
	this.com.townnews.BLOXTotalCMS.resources.generalDocuments.files = this.com.townnews.BLOXTotalCMS.resources.generalDocuments.folder.getFilesWithSuffix('.pdf').sort(CIAscending);
}
//
//
function removeMenu (killThisMenu) {

	//-------------------------------------------------------------------------
	//-- R E M O V E   M E N U
	//-------------------------------------------------------------------------
	//-- Generic: Yes for Adobe InDesign and Adobe InCopy CS3 and newer
	//-------------------------------------------------------------------------
	//-- Purpose: To remove a script created menu
	//-------------------------------------------------------------------------
	//-- Parameters: a String for the name of the menu to remove.
	//-------------------------------------------------------------------------
	//-- Calls: Nothing.
	//-------------------------------------------------------------------------
	//-- Returns: Nothing
	//-------------------------------------------------------------------------
	//-- Sample Use: 
	//~ 	removeMenu ('Utilities') ;
	//-------------------------------------------------------------------------
	//-- Notes: 
	//-------------------------------------------------------------------------
	//-- Written: 2009.11.29 by Jon S. Winters of electronic publishing support
	//-- eps@electronicpublishingsupport.com
	//-------------------------------------------------------------------------
	//-- 3.04 change changing to prevent $ . level induced breaks
	try {

		var mi = app.menus.item("$ID/Main").submenus.item(killThisMenu);
		if (mi != null) {

			mi.remove();

		}

	} catch (err) { ; }

}
//
//
//-- End of File